/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.event;

import io.intino.alexandria.event.Event;
import io.intino.alexandria.event.EventStream;
import io.intino.alexandria.message.Message;
import io.intino.alexandria.zim.ZimReader;
import java.io.File;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;

public class EventReader
implements EventStream {
    private final Iterator<Event> iterator;
    private Event current;

    public EventReader(File file) {
        this(EventReader.iteratorOf(new ZimReader(file).iterator()));
    }

    public EventReader(InputStream is) {
        this(EventReader.iteratorOf(new ZimReader(is).iterator()));
    }

    public EventReader(String text) {
        this(EventReader.iteratorOf(new ZimReader(text).iterator()));
    }

    public EventReader(Event ... events) {
        this(Arrays.stream(events));
    }

    public EventReader(List<Event> events) {
        this(events.stream());
    }

    public EventReader(Stream<Event> stream) {
        this(stream.sorted(Comparator.comparing(Event::ts)).iterator());
    }

    public EventReader(Iterator<Event> iterator) {
        this.iterator = iterator;
    }

    @Override
    public Event current() {
        return this.current;
    }

    @Override
    public Event next() {
        this.current = this.iterator.hasNext() ? this.iterator.next() : null;
        return this.current;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    private static Iterator<Event> iteratorOf(final Iterator<Message> iterator) {
        return new Iterator<Event>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public Event next() {
                return new Event((Message)iterator.next());
            }
        };
    }
}

