/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.drivers.utils;

import io.intino.alexandria.drivers.utils.StringUtils;
import io.intino.alexandria.drivers.utils.SystemOS;
import io.intino.alexandria.logger.Logger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class Shell {
    private String info = "";
    private String response;

    public Integer executeCommand(String command, File path) {
        Integer minimalExitValue = 0;
        return this.executeCommand(command, path, minimalExitValue);
    }

    public Integer executeCommand(String command, File path, Integer minimalExitValue) {
        String[] commands = null;
        Process process = null;
        this.response = "";
        InputStream out = null;
        commands = SystemOS.isWindows() ? new String[]{"cmd", "/c", command} : new String[]{"sh", "-c", command};
        Logger.debug("Execute command: " + command);
        try {
            process = Runtime.getRuntime().exec(commands, null, path);
            process.waitFor();
            out = process.getInputStream();
        }
        catch (IOException | InterruptedException e) {
            Logger.error("Process error: " + e.getMessage());
        }
        StringUtils stringUtils = new StringUtils();
        this.response = stringUtils.getResponse(out);
        this.info = "Exit value: " + process.exitValue() + ". \nOut:\n" + stringUtils.getResponse(process.getInputStream());
        if (process.exitValue() > minimalExitValue) {
            this.info = "Failed to execute: " + command + ", Details: " + this.info + "\nError:\n" + stringUtils.getResponse(process.getErrorStream());
            Logger.error(this.info);
            return process.exitValue();
        }
        Logger.debug(this.info);
        return process.exitValue();
    }

    public String executeCommandWithResponse(String command, File path) {
        Integer minimalExitValue = 0;
        return this.executeCommandWithResponse(command, path, minimalExitValue);
    }

    public String executeCommandWithResponse(String command, File path, Integer minimalExitValue) {
        if (this.executeCommand(command, path, minimalExitValue) == 0) {
            return this.response;
        }
        return "";
    }

    public Integer executeDaemon(String command, File path) {
        String[] commands = null;
        commands = SystemOS.isWindows() ? new String[]{"cmd", "/c", command} : new String[]{"sh", "-c", command};
        Logger.info("Execute command: " + command);
        try {
            Runtime.getRuntime().exec(commands, null, path);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return 0;
    }

    public String lastInfo() {
        return this.info;
    }
}

