/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.drivers.utils;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Properties;

public class SSH {
    private Session session;
    private PrintWriter console;
    private static String error;
    private Integer exitStatus = 0;
    JSch jsch;
    String user;
    String host;
    Integer port;

    public SSH(String privateKey, String user, String host, Integer port, PrintWriter console) throws JSchException {
        this.user = user;
        this.host = host;
        this.port = port;
        this.console = console;
        this.jsch = new JSch();
        this.jsch.addIdentity(privateKey);
        this.session = this.jsch.getSession(user, host, port);
        Properties config = new Properties();
        config.put("StrictHostKeyChecking", "no");
        this.session.setConfig(config);
        this.session.connect();
    }

    public void close() {
        this.session.disconnect();
    }

    public void exec(String command) throws SSHException, JSchException {
        this.exitStatus = 0;
        error = "";
        System.setErr(new PrintStream(new OutputStream(){
            private StringBuilder line = new StringBuilder();

            @Override
            public void write(int b) throws IOException {
                if (b == 10) {
                    String s = this.line.toString();
                    this.line.setLength(0);
                    error = error + (s + '\n');
                } else if (b != 13) {
                    this.line.append((char)b);
                }
            }
        }));
        try {
            Channel channel = this.session.openChannel("exec");
            ((ChannelExec)channel).setCommand(command);
            ((ChannelExec)channel).setErrStream(System.err);
            InputStream in = channel.getInputStream();
            channel.connect();
            byte[] tmp = new byte[10];
            while (true) {
                int i;
                if (in.available() > 0 && (i = in.read(tmp, 0, 10)) >= 0) {
                    this.console.print(new String(tmp, 0, i));
                    this.console.flush();
                    continue;
                }
                if (channel.isClosed() || channel.getExitStatus() > -1) {
                    if (in.available() > 0) continue;
                    break;
                }
                this.waitASecond();
            }
            this.exitStatus = channel.getExitStatus();
            channel.disconnect();
        }
        catch (Exception e) {
            throw new SSHException(e);
        }
    }

    private void waitASecond() {
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getError() {
        return error;
    }

    public Integer getExitStatus() {
        return this.exitStatus;
    }

    public static class SSHException
    extends Exception {
        SSHException(Throwable cause) {
            super(cause);
        }
    }
}

