/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.drivers.shiny;

import io.intino.alexandria.logger.Logger;

public class Setup
extends io.intino.alexandria.drivers.Setup {
    private static String[] SOCompatibles = new String[]{"ubuntu 18.04"};
    private io.intino.alexandria.drivers.r.Setup setupR;

    public Setup() throws Exception {
        new Setup("localhost", 22);
    }

    protected Setup(String host, Integer port) throws Exception {
        super(SOCompatibles, host, port);
        this.setupR = new io.intino.alexandria.drivers.r.Setup(host, port);
    }

    @Override
    public boolean isInstalled() {
        return this.setupR.isInstalled();
    }

    @Override
    public void install() {
        this.setupR.install();
        try {
            this.exec("su - -c \"R -e \\\"install.packages('shiny', repos='https://cran.rstudio.com/')\\\"\"");
            this.exec("apt -y install gdebi-core");
            this.exec("apt -qq list shiny-server");
            if (!this.getLastMessage().contains("installed")) {
                this.exec("wget https://download3.rstudio.org/ubuntu-14.04/x86_64/shiny-server-1.5.9.923-amd64.deb -O shiny-server-1.5.9.923-amd64.deb; gdebi -n shiny-server-1.5.9.923-amd64.deb; rm -f shiny-server-1.5.9.923-amd64.deb");
            }
            this.exec("sed -i \"/disable_protocols/d\" \"/etc/shiny-server/shiny-server.conf\"");
            this.exec("echo \"disable_protocols websocket xdr-streaming xhr-streaming iframe-eventsource iframe-htmlfile xdr-polling xhr-polling iframe-xhr-polling;\" >> \"/etc/shiny-server/shiny-server.conf\"");
            this.exec("echo \"preserve_logs true;\" >> \"/etc/shiny-server/shiny-server.conf\"");
            this.exec("/bin/systemctl restart shiny-server");
            this.exec("apt -y install libcurl4-openssl-dev libssl-dev libxml2-dev libudunits2-dev libgdal-dev");
            this.installPackage("dplyr");
            this.installPackage("fst");
            this.installPackage("ggplot2");
            this.installPackage("plotly");
            this.installPackage("ggmap");
            this.installPackage("sf");
            this.installPackage("tidyverse");
            this.installPackage("classInt");
            this.installPackage("gapminder");
            this.installPackage("gtable");
            this.installPackage("shinydashboard");
            this.installPackage("lubridate");
            this.installPackage("shinyjs");
            this.installPackage("sitools");
        }
        catch (Exception e) {
            Logger.error("Can't exec command in server (ssh). Last command: " + e.getMessage());
        }
    }

    @Override
    public void uninstall() {
        try {
            this.uninstallPackage("sitools");
            this.uninstallPackage("shinyjs");
            this.uninstallPackage("lubridate");
            this.uninstallPackage("shinydashboard");
            this.uninstallPackage("gtable");
            this.uninstallPackage("gapminder");
            this.uninstallPackage("classInt");
            this.uninstallPackage("tidyverse");
            this.uninstallPackage("sf");
            this.uninstallPackage("ggmap");
            this.uninstallPackage("plotly");
            this.uninstallPackage("ggplot2");
            this.uninstallPackage("fst");
            this.uninstallPackage("dplyr");
            this.exec("apt -y purge libcurl4-openssl-dev libssl-dev libxml2-dev libudunits2-dev libgdal-dev");
            this.exec("apt -y purge shiny-server gdebi-core");
            this.uninstallPackage("shiny");
            this.exec("apt -y autoremove");
        }
        catch (Exception e) {
            Logger.error("Can't exec command in server (ssh). Last command: " + e.getMessage());
        }
    }

    private void installPackage(String name) throws Exception {
        if (!this.isInstalledPackage(name)) {
            this.exec("su - -c \"R -e \\\"install.packages('" + name + "')\\\"\"");
        }
    }

    private void uninstallPackage(String name) throws Exception {
        if (this.isInstalledPackage(name)) {
            this.exec("su - -c \"R -e \\\"remove.packages('" + name + "')\\\"\"");
        }
    }

    private boolean isInstalledPackage(String name) throws Exception {
        this.exec("su - -c \"R -e \\\"rownames(installed.packages())\\\"\"");
        return this.getLastMessage().contains("\"" + name + "\"");
    }
}

