/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.drivers.shiny;

import io.intino.alexandria.drivers.Program;
import io.intino.alexandria.drivers.shiny.functions.CleanQueryParam;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.proxy.Proxy;
import io.intino.alexandria.proxy.ProxyAdapter;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public class Driver
implements io.intino.alexandria.drivers.Driver<URL, Proxy> {
    private final String shinyUrl;
    private static final String ShinyScriptsFolder = "/srv/shiny-server";
    public static final String LocalUrlParameter = "LocalUrlParameter";

    public Driver(String shinyUrl) {
        this.shinyUrl = shinyUrl;
    }

    @Override
    public URL info(String program) {
        try {
            return new URL(String.format(this.shinyUrl + "/%s", program));
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    @Override
    public boolean isPublished(String program) {
        if (!this.shinyScriptsFolder().exists()) {
            return true;
        }
        return new File(this.shinyProgramDirectory(program) + "/ui.R").exists() && new File(this.shinyProgramDirectory(program) + "/server.R").exists();
    }

    @Override
    public URL publish(Program program) {
        try {
            String programUrl = this.shinyUrl + "/" + program.name();
            if (!this.shinyScriptsFolder().exists()) {
                return new URL(programUrl);
            }
            this.update(program);
            return new URL(programUrl);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    @Override
    public void update(Program program) {
        if (!this.shinyScriptsFolder().exists()) {
            return;
        }
        this.shinyProgramDirectory(program.name()).mkdirs();
        this.publishScripts(program);
        this.publishResources(program);
    }

    @Override
    public void unPublish(String program) {
        File serverFile;
        File uiFile = new File(this.shinyProgramDirectory(program) + "/ui.R");
        if (uiFile.exists()) {
            uiFile.delete();
        }
        if ((serverFile = new File(this.shinyProgramDirectory(program) + "/server.R")).exists()) {
            serverFile.delete();
        }
    }

    @Override
    public Proxy run(Program program) {
        URL localUrl = (URL)program.parameters().get(LocalUrlParameter);
        return new Proxy(localUrl, this.info(program.name())).adapter(this.proxyAdapter());
    }

    private ProxyAdapter proxyAdapter() {
        return (localUrl, remoteUrl, param, value) -> {
            CleanQueryParam cleanQueryParam = new CleanQueryParam();
            return cleanQueryParam.execute(localUrl, param, value);
        };
    }

    private void publishScripts(Program program) {
        program.scripts().forEach(script -> {
            try {
                Path target = Paths.get(this.shinyProgramDirectory(program.name()) + File.separator + script.name(), new String[0]);
                String scriptContent = new String(IOUtils.toByteArray(script.content()), StandardCharsets.UTF_8);
                scriptContent = this.replaceParameters(program, scriptContent);
                Files.write(target, scriptContent.getBytes(), new OpenOption[0]);
            }
            catch (IOException e) {
                Logger.error(e);
            }
        });
    }

    private void publishResources(Program program) {
        program.resources().forEach(resource -> {
            try {
                File file = new File(this.shinyProgramDirectory(program.name()) + File.separator + resource.name());
                if (file.exists()) {
                    file.delete();
                }
                Files.copy(resource.content(), Paths.get(this.shinyProgramDirectory(program.name()) + File.separator + resource.name(), new String[0]), new CopyOption[0]);
            }
            catch (IOException e) {
                Logger.error(e);
            }
        });
    }

    private String replaceParameters(Program program, String script) {
        Iterator<Map.Entry<String, Object>> iterator = program.parameters().entrySet().iterator();
        while (iterator.hasNext()) {
            Object value;
            Map.Entry<String, Object> entry;
            script = this.replaceTag(script, entry.getKey(), (value = (entry = iterator.next()).getValue()) != null ? String.valueOf(value) : "");
        }
        script = script.replaceAll("###", "");
        return script;
    }

    private String replaceTag(String content, String tag, String value) {
        content = content.replaceAll(":" + tag + ":", value);
        return content;
    }

    private File shinyProgramDirectory(String program) {
        return new File(this.shinyScriptsFolder() + File.separator + program);
    }

    private File shinyScriptsFolder() {
        return new File(ShinyScriptsFolder);
    }
}

