/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.drivers.r.result;

import io.intino.alexandria.drivers.r.Result;
import io.intino.alexandria.logger.Logger;
import java.io.IOException;
import java.io.InputStream;
import org.rosuda.REngine.REXP;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REngineException;
import org.rosuda.REngine.Rserve.RConnection;

public class RemoteResult
implements Result {
    private final RConnection connection;
    private REXP expression;

    public RemoteResult(RConnection connection, REXP expression) {
        this.connection = connection;
        this.expression = expression;
    }

    @Override
    public String getVariable(String name) {
        try {
            if (this.expression == null) {
                return null;
            }
            return this.connection.get(name, this.expression, true).asString();
        }
        catch (REXPMismatchException | REngineException e) {
            Logger.error(e);
            return null;
        }
    }

    @Override
    public InputStream getFile(String filename) {
        try {
            return this.connection.openFile(filename);
        }
        catch (IOException e) {
            Logger.error(e);
            return null;
        }
    }

    @Override
    public void close() {
        if (this.connection != null) {
            this.connection.close();
        }
    }
}

