/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.drivers.r;

import io.intino.alexandria.drivers.Driver;
import io.intino.alexandria.drivers.Program;
import io.intino.alexandria.drivers.r.RScriptBuilder;
import io.intino.alexandria.drivers.r.Result;
import io.intino.alexandria.logger.Logger;
import java.net.URL;
import org.rosuda.REngine.Rserve.RConnection;
import org.rosuda.REngine.Rserve.RserveException;

public class RemoteDriver
implements Driver<URL, Result> {
    private final String host;
    private final int port;
    public static final String Script = "script";
    private static final int DefaultRServePort = 6311;

    public RemoteDriver() {
        this("", 6311);
    }

    public RemoteDriver(String host) {
        this(host, 6311);
    }

    public RemoteDriver(String host, int port) {
        this.host = host;
        this.port = port;
    }

    @Override
    public URL info(String program) {
        return null;
    }

    @Override
    public boolean isPublished(String program) {
        return false;
    }

    @Override
    public URL publish(Program program) {
        return null;
    }

    @Override
    public void update(Program program) {
    }

    @Override
    public void unPublish(String program) {
    }

    @Override
    public Result run(Program program) {
        if (program.scripts().size() <= 0) {
            Logger.error("R driver: No scripts defined in program");
            return null;
        }
        String host = this.host != null ? this.host : "";
        int port = this.port != -1 ? this.port : 6311;
        try {
            RConnection connection = new RConnection(host, port);
            return RScriptBuilder.build(connection, program).run();
        }
        catch (RserveException e) {
            Logger.error("R driver: Could not connect with R server");
            return null;
        }
    }
}

