/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.drivers.r;

import io.intino.alexandria.drivers.r.Result;
import io.intino.alexandria.drivers.r.StreamHelper;
import io.intino.alexandria.drivers.r.result.RemoteResult;
import io.intino.alexandria.logger.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.util.stream.Stream;
import org.rosuda.REngine.REXP;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REngineException;
import org.rosuda.REngine.Rserve.RConnection;
import org.rosuda.REngine.Rserve.RFileOutputStream;

public class RScript {
    private final RConnection connection;
    private REXP rexp = null;

    public RScript(RConnection connection) {
        this.connection = connection;
    }

    public void add(String ... lines) {
        Stream.of(lines).forEach(line -> {
            try {
                this.rexp = this.connection.parseAndEval((String)line);
            }
            catch (REXPMismatchException | REngineException e) {
                Logger.error("Could not add script line", e);
            }
        });
    }

    public void addFile(InputStream content, String name) {
        try {
            RFileOutputStream serverStream = this.connection.createFile(name);
            StreamHelper.copy(content, serverStream);
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    public Result run() {
        return new RemoteResult(this.connection, this.rexp);
    }
}

