/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.drivers.r;

import io.intino.alexandria.drivers.Driver;
import io.intino.alexandria.drivers.Program;
import io.intino.alexandria.drivers.program.Script;
import io.intino.alexandria.drivers.r.Result;
import io.intino.alexandria.drivers.r.result.LocalResult;
import io.intino.alexandria.logger.Logger;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;

public class LocalDriver
implements Driver<URL, Result> {
    private final File workingDirectory;

    public LocalDriver(File workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    @Override
    public URL info(String program) {
        return null;
    }

    @Override
    public boolean isPublished(String program) {
        return false;
    }

    @Override
    public URL publish(Program program) {
        return null;
    }

    @Override
    public void update(Program program) {
    }

    @Override
    public void unPublish(String program) {
    }

    @Override
    public Result run(Program program) {
        File workingDirectory = new File(this.workingDirectory + "/" + program.name());
        if (program.scripts().size() <= 0) {
            Logger.error("R driver: No scripts defined in program");
            return null;
        }
        this.copyResources(program, workingDirectory);
        this.copyScripts(program, workingDirectory);
        program.scripts().forEach(s -> this.runScript(workingDirectory, (Script)s));
        return new LocalResult(workingDirectory);
    }

    private ProcessBuilder runScript(File workingDirectory, Script s) {
        return new ProcessBuilder("Rscript", s.name()).directory(workingDirectory).redirectOutput(ProcessBuilder.Redirect.INHERIT).redirectError(ProcessBuilder.Redirect.INHERIT);
    }

    private void copyScripts(Program program, File workingDirectory) {
        program.scripts().forEach(r -> {
            try {
                Files.copy(r.content(), new File(workingDirectory + r.name()).toPath(), new CopyOption[0]);
            }
            catch (IOException e) {
                Logger.error(e);
            }
        });
    }

    private void copyResources(Program program, File workingDirectory) {
        program.resources().forEach(r -> {
            try {
                Files.copy(r.content(), new File(workingDirectory + r.name()).toPath(), new CopyOption[0]);
            }
            catch (IOException e) {
                Logger.error(e);
            }
        });
    }
}

