/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.drivers;

import io.intino.alexandria.drivers.ISetup;
import io.intino.alexandria.drivers.utils.SSH;
import io.intino.alexandria.drivers.utils.Shell;
import io.intino.alexandria.logger.Logger;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.file.CopyOption;
import java.nio.file.Files;

public class Setup
implements ISetup {
    private String outputLast = "";
    private SSH ssh = null;
    private String soID;
    private String soVersionID;

    protected Setup(String[] SOCompatibles, String host, Integer port) throws Exception {
        try {
            String privateKeyFile = System.getProperty("user.home") + "/.ssh/id_rsa";
            if (!new File(privateKeyFile).isFile()) {
                System.out.println("Private key is missing. Generate new...");
                String command = "/usr/bin/ssh-keygen -t rsa -b 4096 -q -N '' -f " + privateKeyFile;
                System.out.println("Command: " + command);
                new Shell().executeCommand(command, new File(System.getProperty("user.home")));
                String authorized_keys = System.getProperty("user.home") + "/.ssh/authorized_keys";
                Files.copy(new File(privateKeyFile).toPath(), new File(authorized_keys).toPath(), new CopyOption[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        OutputStream output = new OutputStream(){
            private StringBuilder string = new StringBuilder();

            @Override
            public void write(int b) {
                this.string.append((char)b);
                System.out.print((char)b);
                Setup.this.outputLast = Setup.this.outputLast + (char)b;
            }

            public String toString() {
                return this.string.toString();
            }
        };
        PrintWriter console = new PrintWriter(output);
        try {
            this.ssh = new SSH(System.getProperty("user.home") + "/.ssh/id_rsa", "root", host, port, console);
            this.exec("source /etc/os-release; echo -n $ID");
            this.soID = this.outputLast;
            this.exec("source /etc/os-release; echo -n $VERSION_ID");
            this.soVersionID = this.outputLast;
        }
        catch (Exception e) {
            Logger.error("Can't connect to server (ssh)");
        }
        this.checkRequisites(SOCompatibles);
    }

    public Setup() {
    }

    private String getSOCurrentVersion() {
        return this.soID + " " + this.soVersionID;
    }

    private void checkRequisites(String[] SOCompatibles) throws Exception {
        boolean compatible = false;
        for (String so : SOCompatibles) {
            if (!so.equals(this.getSOCurrentVersion())) continue;
            compatible = true;
            break;
        }
        if (!compatible) {
            String message = "Operation system is not compatible. Current version: " + this.getSOCurrentVersion();
            Logger.error(message);
            throw new Exception(message);
        }
    }

    protected String getSOID() {
        return this.soID;
    }

    protected String getSOVERSION_ID() {
        return this.soVersionID;
    }

    protected String getLastMessage() {
        return this.outputLast;
    }

    protected void exec(String command) throws Exception {
        this.outputLast = "";
        Logger.info("Command: " + command);
        this.ssh.exec(command);
        if (this.ssh.getExitStatus() != 0) {
            throw new Exception("Failed to execute command: " + command);
        }
    }

    @Override
    public boolean isInstalled() {
        return false;
    }

    @Override
    public void install() {
    }

    @Override
    public void uninstall() {
    }
}

