/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.drivers;

import io.intino.alexandria.drivers.program.Resource;
import io.intino.alexandria.drivers.program.Script;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Program {
    private String name;
    private List<Script> scripts = new ArrayList<Script>();
    private List<Resource> resources = new ArrayList<Resource>();
    private Map<String, Object> parameters = new HashMap<String, Object>();

    public String name() {
        return this.name;
    }

    public Program name(String name) {
        this.name = name;
        return this;
    }

    public List<Script> scripts() {
        return this.scripts;
    }

    public Program scripts(List<Script> scripts) {
        this.scripts = scripts;
        return this;
    }

    public Program add(String script, String content) {
        this.scripts.add(new Script().name(script).content(new ByteArrayInputStream(content.getBytes())));
        return this;
    }

    public List<Resource> resources() {
        return this.resources;
    }

    public Program resources(List<Resource> resources) {
        this.resources = resources;
        return this;
    }

    public Program add(String resource, InputStream content) {
        this.resources.add(new Resource().name(resource).content(content));
        return this;
    }

    public Map<String, Object> parameters() {
        return this.parameters;
    }

    public Program parameters(Map<String, Object> parameters) {
        this.parameters = parameters;
        return this;
    }
}

