/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria;

import io.intino.alexandria.MimeTypes;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLConnection;

public class Resource {
    private final String name;
    private final String extension;
    private final Metadata metadata;
    private final InputStream inputStream;

    public Resource(String name, byte[] bytes) {
        this(name, null, new ResourceInputStream(bytes));
    }

    public Resource(String name, String contentType, byte[] bytes) {
        this(name, contentType, new ResourceInputStream(bytes));
    }

    public Resource(String name, InputStream inputStream) {
        this(name, null, inputStream);
    }

    public Resource(String name, String contentType, InputStream inputStream) {
        this.name = this.complete(name, contentType);
        this.extension = this.name.substring(name.lastIndexOf(46) + 1);
        this.inputStream = inputStream;
        this.metadata = new Metadata(contentType);
    }

    private String complete(String name, String contentType) {
        if (contentType == null) {
            return name;
        }
        String extension = this.extensionOf(contentType);
        return name + (name.endsWith(extension) ? "" : extension);
    }

    private String extensionOf(String contentType) {
        if (contentType == null) {
            return "";
        }
        return MimeTypes.extensionOf(contentType);
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.extension;
    }

    public byte[] bytes() {
        return this.inputStream instanceof ResourceInputStream ? this.resourceInputStream().bytes() : Resource.read(this.stream());
    }

    public InputStream stream() {
        return this.inputStream instanceof ResourceInputStream ? this.resourceInputStream() : this.inputStream;
    }

    private ResourceInputStream resourceInputStream() {
        ResourceInputStream stream = (ResourceInputStream)this.inputStream;
        stream.reset();
        return stream;
    }

    public Metadata metadata() {
        return this.metadata;
    }

    private static byte[] read(InputStream input) {
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            Resource.copy(input, output);
            return output.toByteArray();
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public String toString() {
        return this.name;
    }

    public static Resource parse(String line) {
        int i = line.indexOf(64);
        String name = i >= 0 ? line.substring(0, i) : line;
        byte[] data = i >= 0 ? line.substring(i + 1).getBytes() : new byte[]{};
        return new Resource(name, data);
    }

    public static int copy(InputStream input, OutputStream output) throws IOException {
        long count = Resource.copyLarge(input, output);
        if (count > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count;
    }

    public static long copyLarge(InputStream input, OutputStream output) throws IOException {
        return Resource.copyLarge(input, output, new byte[4096]);
    }

    public static long copyLarge(InputStream input, OutputStream output, byte[] buffer) throws IOException {
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    private static class ResourceInputStream
    extends ByteArrayInputStream {
        ResourceInputStream(byte[] buf) {
            super(buf);
        }

        byte[] bytes() {
            return this.buf;
        }
    }

    public class Metadata {
        private String mimeType;
        private String contentType;

        Metadata(String contentType) {
            this.mimeType = URLConnection.getFileNameMap().getContentTypeFor(Resource.this.name);
            this.contentType = contentType == null ? URLConnection.guessContentTypeFromName(Resource.this.name) : contentType;
        }

        public String mimeType() {
            return this.mimeType;
        }

        public String contentType() {
            return this.contentType != null ? this.contentType : this.resolveContentType();
        }

        public Resource contentType(String contentType) {
            this.contentType = contentType;
            return Resource.this;
        }

        private String resolveContentType() {
            try {
                return Resource.this.inputStream instanceof ByteArrayInputStream ? URLConnection.guessContentTypeFromStream(Resource.this.stream()) : null;
            }
            catch (IOException e) {
                return null;
            }
        }
    }
}

