/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.konos;

import io.intino.consul.konos.jmx.ConsulMBean;
import io.intino.consul.konos.schemas.Artifactory;
import io.intino.consul.konos.schemas.ServerStatus;
import io.intino.consul.konos.schemas.SystemLog;
import io.intino.consul.konos.schemas.SystemSchema;
import io.intino.consul.konos.schemas.SystemStatus;
import io.intino.konos.jmx.JMXClient;
import java.io.IOException;

public class ConsulJMXAccessor {
    private final JMXClient.JMXConnection connection;
    private ConsulMBean bean;

    public ConsulJMXAccessor(String url, int port) throws IOException {
        JMXClient server = new JMXClient(url, port);
        this.connection = server.connect();
        this.bean = (ConsulMBean)this.connection.mBean(ConsulMBean.class);
    }

    public void closeJMXConnection() {
        this.connection.close();
    }

    public Boolean deploy(SystemSchema system) {
        return this.bean != null ? this.bean.deploy(system) : null;
    }

    public Boolean retract(String systemID) {
        return this.bean != null ? this.bean.retract(systemID) : null;
    }

    public Boolean startSystem(String systemID) {
        return this.bean != null ? this.bean.startSystem(systemID) : null;
    }

    public Boolean stopSystem(String systemID) {
        return this.bean != null ? this.bean.stopSystem(systemID) : null;
    }

    public Boolean debugSystem(String systemID, Integer port) {
        return this.bean != null ? this.bean.debugSystem(systemID, port) : null;
    }

    public Boolean restartSystem(String systemID) {
        return this.bean != null ? this.bean.restartSystem(systemID) : null;
    }

    public Boolean parameter(String systemID, String name, String value) {
        return this.bean != null ? this.bean.parameter(systemID, name, value) : null;
    }

    public SystemStatus systemStatus(String systemID) {
        return this.bean != null ? this.bean.systemStatus(systemID) : null;
    }

    public SystemLog systemLog(String systemID) {
        return this.bean != null ? this.bean.systemLog(systemID) : null;
    }

    public ServerStatus serverStatus() {
        return this.bean != null ? this.bean.serverStatus() : null;
    }

    public Boolean upgradeConsul(String version, Artifactory artifactory) {
        return this.bean != null ? this.bean.upgradeConsul(version, artifactory) : null;
    }
}

