package io.intino.consul.konos;

import java.util.List;
import java.util.ArrayList;
import io.intino.konos.exceptions.*;
import io.intino.consul.konos.jmx.ConsulMBean;
import io.intino.konos.jmx.JMXClient;

import io.intino.consul.konos.schemas.*;

public class ConsulJMXAccessor {

	private final JMXClient.JMXConnection connection;
	private ConsulMBean bean;

	public ConsulJMXAccessor(String url, int port) throws java.io.IOException {
		JMXClient server = new JMXClient(url, port);
		connection = server.connect();
		bean = connection.mBean(ConsulMBean.class);
	}

	public void closeJMXConnection() {
		connection.close();
	}

	public Boolean deploy(io.intino.consul.konos.schemas.SystemSchema system) {
		return bean != null ? bean.deploy(system) : null;
	}

	public Boolean retract(String systemID) {
		return bean != null ? bean.retract(systemID) : null;
	}

	public Boolean startSystem(String systemID) {
		return bean != null ? bean.startSystem(systemID) : null;
	}

	public Boolean stopSystem(String systemID) {
		return bean != null ? bean.stopSystem(systemID) : null;
	}

	public Boolean debugSystem(String systemID, Integer port) {
		return bean != null ? bean.debugSystem(systemID, port) : null;
	}

	public Boolean restartSystem(String systemID) {
		return bean != null ? bean.restartSystem(systemID) : null;
	}

	public Boolean parameter(String systemID, String name, String value) {
		return bean != null ? bean.parameter(systemID, name, value) : null;
	}

	public io.intino.consul.konos.schemas.SystemStatus systemStatus(String systemID) {
		return bean != null ? bean.systemStatus(systemID) : null;
	}

	public io.intino.consul.konos.schemas.SystemLog systemLog(String systemID) {
		return bean != null ? bean.systemLog(systemID) : null;
	}

	public io.intino.consul.konos.schemas.ServerStatus serverStatus() {
		return bean != null ? bean.serverStatus() : null;
	}

	public Boolean upgradeConsul(String version, io.intino.consul.konos.schemas.Artifactory artifactory) {
		return bean != null ? bean.upgradeConsul(version, artifactory) : null;
	}
}