/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul;

import io.intino.alexandria.jms.QueueProducer;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.message.Message;
import io.intino.alexandria.message.MessageReader;
import io.intino.cesar.datahub.events.Deploy;
import io.intino.cesar.datahub.events.DeployResult;
import io.intino.cesar.datahub.events.OperationResult;
import io.intino.cesar.datahub.events.Operations;
import io.intino.cesar.datahub.events.consul.process.ProcessLog;
import io.intino.cesar.datahub.events.consul.process.ProcessStatus;
import io.intino.cesar.datahub.events.consul.server.ServerStatus;
import java.util.List;
import java.util.Random;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.TextMessage;

public class ConsulJmsAccessor {
    private final Session session;
    private final String serverid;

    public ConsulJmsAccessor(Session session, String serverid) {
        this.session = session;
        this.serverid = serverid;
    }

    public MessageConsumer status(StatusResponse callback) throws JMSException {
        TemporaryQueue temporaryQueue = this.session.createTemporaryQueue();
        MessageConsumer consumer = this.session.createConsumer(temporaryQueue);
        consumer.setMessageListener(callback);
        TextMessage message = this.createMessage(temporaryQueue);
        QueueProducer producer = new QueueProducer(this.session, "service.consul.{serverId}.status".replace("{serverId}", this.serverid));
        producer.produce(message);
        producer.close();
        return consumer;
    }

    public MessageConsumer reboot(RebootResponse callback) throws JMSException {
        TemporaryQueue temporaryQueue = this.session.createTemporaryQueue();
        MessageConsumer consumer = this.session.createConsumer(temporaryQueue);
        consumer.setMessageListener(callback);
        TextMessage message = this.createMessage(temporaryQueue);
        QueueProducer producer = new QueueProducer(this.session, "service.consul.{serverId}.reboot".replace("{serverId}", this.serverid));
        producer.produce(message);
        producer.close();
        return consumer;
    }

    public MessageConsumer deploy(Deploy deploy, DeployResponse callback) throws JMSException {
        TemporaryQueue temporaryQueue = this.session.createTemporaryQueue();
        MessageConsumer consumer = this.session.createConsumer(temporaryQueue);
        consumer.setMessageListener(callback);
        TextMessage message = this.createMessage(temporaryQueue);
        message.setText(deploy.toMessage().toString());
        QueueProducer producer = new QueueProducer(this.session, "service.consul.{serverId}.deploy".replace("{serverId}", this.serverid));
        producer.produce(message);
        producer.close();
        return consumer;
    }

    public MessageConsumer retract(String processId, RetractResponse callback) throws JMSException {
        TemporaryQueue temporaryQueue = this.session.createTemporaryQueue();
        MessageConsumer consumer = this.session.createConsumer(temporaryQueue);
        consumer.setMessageListener(callback);
        TextMessage message = this.createMessage(temporaryQueue);
        message.setText(this.messageFor("Retract", processId));
        QueueProducer producer = new QueueProducer(this.session, "service.consul.{serverId}.retract".replace("{serverId}", this.serverid));
        producer.produce(message);
        producer.close();
        return consumer;
    }

    public MessageConsumer upgrade(UpgradeResponse callback) throws JMSException {
        TemporaryQueue temporaryQueue = this.session.createTemporaryQueue();
        MessageConsumer consumer = this.session.createConsumer(temporaryQueue);
        consumer.setMessageListener(callback);
        TextMessage message = this.createMessage(temporaryQueue);
        QueueProducer producer = new QueueProducer(this.session, "service.consul.{serverId}.upgrade".replace("{serverId}", this.serverid));
        producer.produce(message);
        producer.close();
        return consumer;
    }

    public MessageConsumer startProcess(String processId, StartProcessResponse callback) throws JMSException {
        TemporaryQueue temporaryQueue = this.session.createTemporaryQueue();
        MessageConsumer consumer = this.session.createConsumer(temporaryQueue);
        consumer.setMessageListener(callback);
        TextMessage message = this.createMessage(temporaryQueue);
        message.setText(this.messageFor("StartProcess", processId));
        QueueProducer producer = new QueueProducer(this.session, "service.consul.{serverId}.startProcess".replace("{serverId}", this.serverid));
        producer.produce(message);
        producer.close();
        return consumer;
    }

    public MessageConsumer stopProcess(String processId, StopProcessResponse callback) throws JMSException {
        TemporaryQueue temporaryQueue = this.session.createTemporaryQueue();
        MessageConsumer consumer = this.session.createConsumer(temporaryQueue);
        consumer.setMessageListener(callback);
        TextMessage message = this.createMessage(temporaryQueue);
        message.setText(this.messageFor("StopProcess", processId));
        QueueProducer producer = new QueueProducer(this.session, "service.consul.{serverId}.stopProcess".replace("{serverId}", this.serverid));
        producer.produce(message);
        producer.close();
        return consumer;
    }

    public MessageConsumer debugProcess(String processId, Integer port, DebugProcessResponse callback) throws JMSException {
        TemporaryQueue temporaryQueue = this.session.createTemporaryQueue();
        MessageConsumer consumer = this.session.createConsumer(temporaryQueue);
        consumer.setMessageListener(callback);
        TextMessage message = this.createMessage(temporaryQueue);
        this.fillDebugProcess(message, processId, port);
        QueueProducer producer = new QueueProducer(this.session, "service.consul.{serverId}.debugProcess".replace("{serverId}", this.serverid));
        producer.produce(message);
        producer.close();
        return consumer;
    }

    private void fillDebugProcess(TextMessage message, String processId, Integer port) throws JMSException {
        Message debugProcess = new Message("DebugProcess").set("processId", processId).set("port", port);
        message.setText(debugProcess.toString());
    }

    public MessageConsumer restartProcess(String processId, RestartProcessResponse callback) throws JMSException {
        TemporaryQueue temporaryQueue = this.session.createTemporaryQueue();
        MessageConsumer consumer = this.session.createConsumer(temporaryQueue);
        consumer.setMessageListener(callback);
        TextMessage message = this.createMessage(temporaryQueue);
        message.setText(this.messageFor("RestartProcess", processId));
        QueueProducer producer = new QueueProducer(this.session, "service.consul.{serverId}.restartProcess".replace("{serverId}", this.serverid));
        producer.produce(message);
        producer.close();
        return consumer;
    }

    public MessageConsumer resetProcess(String processId, ResetProcessResponse callback) throws JMSException {
        TemporaryQueue temporaryQueue = this.session.createTemporaryQueue();
        MessageConsumer consumer = this.session.createConsumer(temporaryQueue);
        consumer.setMessageListener(callback);
        TextMessage message = this.createMessage(temporaryQueue);
        message.setText(this.messageFor("ResetProcess", processId));
        QueueProducer producer = new QueueProducer(this.session, "service.consul.{serverId}.resetProcess".replace("{serverId}", this.serverid));
        producer.produce(message);
        producer.close();
        return consumer;
    }

    public MessageConsumer parameter(String processId, String name, String value, ParameterResponse callback) throws JMSException {
        TemporaryQueue temporaryQueue = this.session.createTemporaryQueue();
        MessageConsumer consumer = this.session.createConsumer(temporaryQueue);
        consumer.setMessageListener(callback);
        TextMessage message = this.createMessage(temporaryQueue);
        this.fillParameter(message, processId, name, value);
        QueueProducer producer = new QueueProducer(this.session, "service.consul.{serverId}.parameter".replace("{serverId}", this.serverid));
        producer.produce(message);
        producer.close();
        return consumer;
    }

    private void fillParameter(TextMessage message, String processId, String name, String value) throws JMSException {
        Message parameter = new Message("Parameter").set("processId", processId).set("name", name).set("value", value);
        message.setText(parameter.toString());
    }

    public MessageConsumer processStatus(String processId, ProcessStatusResponse callback) throws JMSException {
        TemporaryQueue temporaryQueue = this.session.createTemporaryQueue();
        MessageConsumer consumer = this.session.createConsumer(temporaryQueue);
        consumer.setMessageListener(callback);
        TextMessage message = this.createMessage(temporaryQueue);
        message.setText(this.messageFor("ProcessStatus", processId));
        QueueProducer producer = new QueueProducer(this.session, "service.consul.{serverId}.processStatus".replace("{serverId}", this.serverid));
        producer.produce(message);
        producer.close();
        return consumer;
    }

    public MessageConsumer processLog(String processId, ProcessLogResponse callback) throws JMSException {
        TemporaryQueue temporaryQueue = this.session.createTemporaryQueue();
        MessageConsumer consumer = this.session.createConsumer(temporaryQueue);
        consumer.setMessageListener(callback);
        TextMessage message = this.createMessage(temporaryQueue);
        message.setText(this.messageFor("ProcessLog", processId));
        QueueProducer producer = new QueueProducer(this.session, "service.consul.{serverId}.processLog".replace("{serverId}", this.serverid));
        producer.produce(message);
        producer.close();
        return consumer;
    }

    private String messageFor(String type, String processId) {
        return new Message(type).set("processId", processId).toString();
    }

    public MessageConsumer processOperation(Operations.Operation operation, ProcessOperationResponse callback) throws JMSException {
        TemporaryQueue temporaryQueue = this.session.createTemporaryQueue();
        MessageConsumer consumer = this.session.createConsumer(temporaryQueue);
        consumer.setMessageListener(callback);
        TextMessage message = this.createMessage(temporaryQueue);
        message.setText(operation.toMessage().toString());
        QueueProducer producer = new QueueProducer(this.session, "service.consul.{serverId}.operate".replace("{serverId}", this.serverid));
        producer.produce(message);
        producer.close();
        return consumer;
    }

    public MessageConsumer processOperations(String processId, ProcessOperationsResponse callback) throws JMSException {
        TemporaryQueue temporaryQueue = this.session.createTemporaryQueue();
        MessageConsumer consumer = this.session.createConsumer(temporaryQueue);
        consumer.setMessageListener(callback);
        TextMessage message = this.createMessage(temporaryQueue);
        message.setText(this.messageFor("processOperations", processId));
        QueueProducer producer = new QueueProducer(this.session, "service.consul.{serverId}.operations".replace("{serverId}", this.serverid));
        producer.produce(message);
        producer.close();
        return consumer;
    }

    private TextMessage createMessage(Destination temporaryQueue) throws JMSException {
        TextMessage message = this.session.createTextMessage();
        message.setJMSReplyTo(temporaryQueue);
        message.setJMSCorrelationID(ConsulJmsAccessor.createRandomString());
        return message;
    }

    private static String createRandomString() {
        Random random = new Random(System.currentTimeMillis());
        long randomLong = random.nextLong();
        return Long.toHexString(randomLong);
    }

    public static interface ProcessOperationsResponse
    extends MessageListener {
        public void callback(List<Operations.Operation> var1);

        @Override
        default public void onMessage(javax.jms.Message message) {
            try {
                this.callback(new Operations(new MessageReader(((TextMessage)message).getText()).next()).operationList());
            }
            catch (JMSException e) {
                Logger.error(e);
            }
        }
    }

    public static interface ProcessOperationResponse
    extends MessageListener {
        public void callback(OperationResult var1);

        @Override
        default public void onMessage(javax.jms.Message message) {
            try {
                this.callback(new OperationResult(new MessageReader(((TextMessage)message).getText()).next()));
            }
            catch (JMSException e) {
                Logger.error(e);
            }
        }
    }

    public static interface ProcessLogResponse
    extends MessageListener {
        public void callback(ProcessLog var1);

        @Override
        default public void onMessage(javax.jms.Message message) {
            try {
                this.callback(new ProcessLog(new MessageReader(((TextMessage)message).getText()).next()));
            }
            catch (JMSException e) {
                Logger.error(e);
            }
        }
    }

    public static interface ProcessStatusResponse
    extends MessageListener {
        public void callback(ProcessStatus var1);

        @Override
        default public void onMessage(javax.jms.Message message) {
            try {
                this.callback(new ProcessStatus(new MessageReader(((TextMessage)message).getText()).next()));
            }
            catch (JMSException e) {
                Logger.error(e);
            }
        }
    }

    public static interface ParameterResponse
    extends MessageListener {
        public void callback(Boolean var1);

        @Override
        default public void onMessage(javax.jms.Message message) {
            try {
                this.callback(Boolean.parseBoolean(((TextMessage)message).getText()));
            }
            catch (JMSException e) {
                Logger.error(e);
            }
        }
    }

    public static interface ResetProcessResponse
    extends MessageListener {
        public void callback(Boolean var1);

        @Override
        default public void onMessage(javax.jms.Message message) {
            try {
                this.callback(Boolean.parseBoolean(((TextMessage)message).getText()));
            }
            catch (JMSException e) {
                Logger.error(e);
            }
        }
    }

    public static interface RestartProcessResponse
    extends MessageListener {
        public void callback(Boolean var1);

        @Override
        default public void onMessage(javax.jms.Message message) {
            try {
                this.callback(Boolean.parseBoolean(((TextMessage)message).getText()));
            }
            catch (JMSException e) {
                Logger.error(e);
            }
        }
    }

    public static interface DebugProcessResponse
    extends MessageListener {
        public void callback(Boolean var1);

        @Override
        default public void onMessage(javax.jms.Message message) {
            try {
                this.callback(Boolean.parseBoolean(((TextMessage)message).getText()));
            }
            catch (JMSException e) {
                Logger.error(e);
            }
        }
    }

    public static interface StopProcessResponse
    extends MessageListener {
        public void callback(Boolean var1);

        @Override
        default public void onMessage(javax.jms.Message message) {
            try {
                this.callback(Boolean.parseBoolean(((TextMessage)message).getText()));
            }
            catch (JMSException e) {
                Logger.error(e);
            }
        }
    }

    public static interface StartProcessResponse
    extends MessageListener {
        public void callback(Boolean var1);

        @Override
        default public void onMessage(javax.jms.Message message) {
            try {
                this.callback(Boolean.parseBoolean(((TextMessage)message).getText()));
            }
            catch (JMSException e) {
                Logger.error(e);
            }
        }
    }

    public static interface UpgradeResponse
    extends MessageListener {
        public void callback(Boolean var1);

        @Override
        default public void onMessage(javax.jms.Message message) {
            try {
                this.callback(Boolean.parseBoolean(((TextMessage)message).getText()));
            }
            catch (JMSException e) {
                Logger.error(e);
            }
        }
    }

    public static interface RetractResponse
    extends MessageListener {
        public void callback(Boolean var1);

        @Override
        default public void onMessage(javax.jms.Message message) {
            try {
                this.callback(Boolean.parseBoolean(((TextMessage)message).getText()));
            }
            catch (JMSException e) {
                Logger.error(e);
            }
        }
    }

    public static interface DeployResponse
    extends MessageListener {
        public void callback(DeployResult var1);

        @Override
        default public void onMessage(javax.jms.Message message) {
            try {
                this.callback(new DeployResult(new MessageReader(((TextMessage)message).getText()).next()));
            }
            catch (JMSException e) {
                Logger.error(e);
            }
        }
    }

    public static interface RebootResponse
    extends MessageListener {
        public void callback(Boolean var1);

        @Override
        default public void onMessage(javax.jms.Message message) {
            try {
                this.callback(Boolean.parseBoolean(((TextMessage)message).getText()));
            }
            catch (JMSException e) {
                Logger.error(e);
            }
        }
    }

    public static interface StatusResponse
    extends MessageListener {
        public void callback(ServerStatus var1);

        @Override
        default public void onMessage(javax.jms.Message message) {
            try {
                this.callback(new ServerStatus(new MessageReader(((TextMessage)message).getText()).next()));
            }
            catch (JMSException e) {
                Logger.error(e);
            }
        }
    }
}

