/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.graph;

import io.intino.cesar.graph.CesarGraph;
import io.intino.magritte.framework.Expression;
import io.intino.magritte.framework.Layer;
import io.intino.magritte.framework.Node;
import io.intino.magritte.framework.loaders.FunctionLoader;
import io.intino.magritte.framework.loaders.StringLoader;
import io.intino.magritte.framework.tags.Component;
import io.intino.magritte.framework.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Artifact
extends Layer
implements Component,
Terminal {
    protected String group;
    protected String artifactId;
    protected String version;
    protected Expression<String> identifier;
    protected String classpathPrefix;
    protected List<Artifactory> artifactoryList = new ArrayList<Artifactory>();

    public Artifact(Node node) {
        super(node);
    }

    public String group() {
        return this.group;
    }

    public String artifactId() {
        return this.artifactId;
    }

    public String version() {
        return this.version;
    }

    public String identifier() {
        return this.identifier.value();
    }

    public String classpathPrefix() {
        return this.classpathPrefix;
    }

    public Artifact group(String value) {
        this.group = value;
        return this;
    }

    public Artifact artifactId(String value) {
        this.artifactId = value;
        return this;
    }

    public Artifact version(String value) {
        this.version = value;
        return this;
    }

    public Artifact identifier(Expression<String> value) {
        this.identifier = FunctionLoader.load(value, (Layer)this, Expression.class);
        return this;
    }

    public Artifact classpathPrefix(String value) {
        this.classpathPrefix = value;
        return this;
    }

    public List<Artifactory> artifactoryList() {
        return Collections.unmodifiableList(this.artifactoryList);
    }

    public Artifactory artifactory(int index) {
        return this.artifactoryList.get(index);
    }

    public List<Artifactory> artifactoryList(Predicate<Artifactory> predicate) {
        return this.artifactoryList().stream().filter(predicate).collect(Collectors.toList());
    }

    public Artifactory artifactory(Predicate<Artifactory> predicate) {
        return this.artifactoryList().stream().filter(predicate).findFirst().orElse(null);
    }

    @Override
    protected List<Node> componentList$() {
        LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
        new ArrayList<Artifactory>(this.artifactoryList).forEach(c -> components.add(c.core$()));
        return new ArrayList<Node>(components);
    }

    @Override
    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap();
        map.put("group", new ArrayList<String>(Collections.singletonList(this.group)));
        map.put("artifactId", new ArrayList<String>(Collections.singletonList(this.artifactId)));
        map.put("version", new ArrayList<String>(Collections.singletonList(this.version)));
        map.put("identifier", new ArrayList<Expression<String>>(Collections.singletonList(this.identifier)));
        map.put("classpathPrefix", new ArrayList<String>(Collections.singletonList(this.classpathPrefix)));
        return map;
    }

    @Override
    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("Artifact$Artifactory")) {
            this.artifactoryList.add(node.as(Artifactory.class));
        }
    }

    @Override
    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("Artifact$Artifactory")) {
            this.artifactoryList.remove(node.as(Artifactory.class));
        }
    }

    @Override
    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("group")) {
            this.group = StringLoader.load(values, this).get(0);
        } else if (name.equalsIgnoreCase("artifactId")) {
            this.artifactId = StringLoader.load(values, this).get(0);
        } else if (name.equalsIgnoreCase("version")) {
            this.version = StringLoader.load(values, this).get(0);
        } else if (name.equalsIgnoreCase("identifier")) {
            this.identifier = FunctionLoader.load(values, (Layer)this, Expression.class).get(0);
        } else if (name.equalsIgnoreCase("classpathPrefix")) {
            this.classpathPrefix = StringLoader.load(values, this).get(0);
        }
    }

    @Override
    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("group")) {
            this.group = (String)values.get(0);
        } else if (name.equalsIgnoreCase("artifactId")) {
            this.artifactId = (String)values.get(0);
        } else if (name.equalsIgnoreCase("version")) {
            this.version = (String)values.get(0);
        } else if (name.equalsIgnoreCase("identifier")) {
            this.identifier = FunctionLoader.load(values.get(0), (Layer)this, Expression.class);
        } else if (name.equalsIgnoreCase("classpathPrefix")) {
            this.classpathPrefix = (String)values.get(0);
        }
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    public CesarGraph graph() {
        return this.core$().graph().as(CesarGraph.class);
    }

    public static class Artifactory
    extends Layer
    implements Terminal {
        protected String url;
        protected String mavenId;
        protected Authentication authentication;

        public Artifactory(Node node) {
            super(node);
        }

        public String url() {
            return this.url;
        }

        public String mavenId() {
            return this.mavenId;
        }

        public Artifactory url(String value) {
            this.url = value;
            return this;
        }

        public Artifactory mavenId(String value) {
            this.mavenId = value;
            return this;
        }

        public Authentication authentication() {
            return this.authentication;
        }

        @Override
        protected List<Node> componentList$() {
            LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
            if (this.authentication != null) {
                components.add(this.authentication.core$());
            }
            return new ArrayList<Node>(components);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("url", new ArrayList<String>(Collections.singletonList(this.url)));
            map.put("mavenId", new ArrayList<String>(Collections.singletonList(this.mavenId)));
            return map;
        }

        @Override
        protected void addNode$(Node node) {
            super.addNode$(node);
            if (node.is("Artifact$Artifactory$Authentication")) {
                this.authentication = node.as(Authentication.class);
            }
        }

        @Override
        protected void removeNode$(Node node) {
            super.removeNode$(node);
            if (node.is("Artifact$Artifactory$Authentication")) {
                this.authentication = null;
            }
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("url")) {
                this.url = StringLoader.load(values, this).get(0);
            } else if (name.equalsIgnoreCase("mavenId")) {
                this.mavenId = StringLoader.load(values, this).get(0);
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("url")) {
                this.url = (String)values.get(0);
            } else if (name.equalsIgnoreCase("mavenId")) {
                this.mavenId = (String)values.get(0);
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public CesarGraph graph() {
            return this.core$().graph().as(CesarGraph.class);
        }

        public static class Authentication
        extends Layer
        implements Terminal {
            protected String user;
            protected String password;

            public Authentication(Node node) {
                super(node);
            }

            public String user() {
                return this.user;
            }

            public String password() {
                return this.password;
            }

            public Authentication user(String value) {
                this.user = value;
                return this;
            }

            public Authentication password(String value) {
                this.password = value;
                return this;
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("user", new ArrayList<String>(Collections.singletonList(this.user)));
                map.put("password", new ArrayList<String>(Collections.singletonList(this.password)));
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("user")) {
                    this.user = StringLoader.load(values, this).get(0);
                } else if (name.equalsIgnoreCase("password")) {
                    this.password = StringLoader.load(values, this).get(0);
                }
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("user")) {
                    this.user = (String)values.get(0);
                } else if (name.equalsIgnoreCase("password")) {
                    this.password = (String)values.get(0);
                }
            }

            public CesarGraph graph() {
                return this.core$().graph().as(CesarGraph.class);
            }
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Authentication authentication(String user, String password) {
                Authentication newElement = Artifactory.this.core$().graph().concept(Authentication.class).createNode(this.name, Artifactory.this.core$()).as(Authentication.class);
                newElement.core$().set(newElement, "user", Collections.singletonList(user));
                newElement.core$().set(newElement, "password", Collections.singletonList(password));
                return newElement;
            }
        }
    }

    public class Clear {
        public void artifactory(Predicate<Artifactory> filter) {
            new ArrayList<Artifactory>(Artifact.this.artifactoryList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }

        public Artifactory artifactory(String url, String mavenId) {
            Artifactory newElement = Artifact.this.core$().graph().concept(Artifactory.class).createNode(this.name, Artifact.this.core$()).as(Artifactory.class);
            newElement.core$().set(newElement, "url", Collections.singletonList(url));
            newElement.core$().set(newElement, "mavenId", Collections.singletonList(mavenId));
            return newElement;
        }
    }
}

