/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.graph;

import io.intino.cesar.graph.Artifact;
import io.intino.cesar.graph.CesarGraph;
import io.intino.cesar.graph.Operation;
import io.intino.cesar.graph.Perceptible;
import io.intino.cesar.graph.Process;
import io.intino.cesar.graph.ServerConsul;
import io.intino.cesar.graph.rules.IssueType;
import io.intino.magritte.framework.Layer;
import io.intino.magritte.framework.Node;
import io.intino.magritte.framework.loaders.BooleanLoader;
import io.intino.magritte.framework.loaders.DoubleLoader;
import io.intino.magritte.framework.loaders.InstantLoader;
import io.intino.magritte.framework.loaders.IntegerLoader;
import io.intino.magritte.framework.loaders.NodeLoader;
import io.intino.magritte.framework.loaders.ResourceLoader;
import io.intino.magritte.framework.loaders.StringLoader;
import io.intino.magritte.framework.loaders.WordLoader;
import io.intino.magritte.framework.tags.Component;
import io.intino.magritte.framework.tags.Terminal;
import java.io.InputStream;
import java.net.URL;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public abstract class AbstractProcess
extends Perceptible
implements Component,
Terminal {
    protected String identifier;
    protected String vcs;
    protected boolean started;
    protected boolean debugging;
    protected int debugPort;
    protected ServerConsul consul;
    protected List<IssueType> activeIssueSensors = new ArrayList<IssueType>();
    protected List<Process.Deployment> deploymentList = new ArrayList<Process.Deployment>();
    protected Process.Operations operations;
    protected Process.Registry registry;

    public AbstractProcess(Node node) {
        super(node);
    }

    public String identifier() {
        return this.identifier;
    }

    public String vcs() {
        return this.vcs;
    }

    public boolean started() {
        return this.started;
    }

    public boolean debugging() {
        return this.debugging;
    }

    public int debugPort() {
        return this.debugPort;
    }

    public ServerConsul consul() {
        return this.consul;
    }

    public Process identifier(String value) {
        this.identifier = value;
        return (Process)this;
    }

    public Process vcs(String value) {
        this.vcs = value;
        return (Process)this;
    }

    public Process started(boolean value) {
        this.started = value;
        return (Process)this;
    }

    public Process debugging(boolean value) {
        this.debugging = value;
        return (Process)this;
    }

    public Process debugPort(int value) {
        this.debugPort = value;
        return (Process)this;
    }

    public Process consul(ServerConsul value) {
        this.consul = value;
        return (Process)this;
    }

    public List<Process.Deployment> deploymentList() {
        return Collections.unmodifiableList(this.deploymentList);
    }

    public Process.Deployment deployment(int index) {
        return this.deploymentList.get(index);
    }

    public List<Process.Deployment> deploymentList(Predicate<Process.Deployment> predicate) {
        return this.deploymentList().stream().filter(predicate).collect(Collectors.toList());
    }

    public Process.Deployment deployment(Predicate<Process.Deployment> predicate) {
        return this.deploymentList().stream().filter(predicate).findFirst().orElse(null);
    }

    public Process.Operations operations() {
        return this.operations;
    }

    public Process.Registry registry() {
        return this.registry;
    }

    @Override
    protected List<Node> componentList$() {
        LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
        new ArrayList<Process.Deployment>(this.deploymentList).forEach(c -> components.add(c.core$()));
        if (this.operations != null) {
            components.add(this.operations.core$());
        }
        if (this.registry != null) {
            components.add(this.registry.core$());
        }
        return new ArrayList<Node>(components);
    }

    @Override
    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap(super.variables$());
        map.put("identifier", new ArrayList<String>(Collections.singletonList(this.identifier)));
        map.put("vcs", new ArrayList<String>(Collections.singletonList(this.vcs)));
        map.put("started", new ArrayList<Boolean>(Collections.singletonList(this.started)));
        map.put("debugging", new ArrayList<Boolean>(Collections.singletonList(this.debugging)));
        map.put("debugPort", new ArrayList<Integer>(Collections.singletonList(this.debugPort)));
        map.put("consul", this.consul != null ? new ArrayList<ServerConsul>(Collections.singletonList(this.consul)) : Collections.emptyList());
        return map;
    }

    @Override
    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("Process$Deployment")) {
            this.deploymentList.add(node.as(Process.Deployment.class));
        }
        if (node.is("Process$Operations")) {
            this.operations = node.as(Process.Operations.class);
        }
        if (node.is("Process$Registry")) {
            this.registry = node.as(Process.Registry.class);
        }
    }

    @Override
    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("Process$Deployment")) {
            this.deploymentList.remove(node.as(Process.Deployment.class));
        }
        if (node.is("Process$Operations")) {
            this.operations = null;
        }
        if (node.is("Process$Registry")) {
            this.registry = null;
        }
    }

    @Override
    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("identifier")) {
            this.identifier = StringLoader.load(values, this).get(0);
        } else if (name.equalsIgnoreCase("vcs")) {
            this.vcs = StringLoader.load(values, this).get(0);
        } else if (name.equalsIgnoreCase("started")) {
            this.started = BooleanLoader.load(values, this).get(0);
        } else if (name.equalsIgnoreCase("debugging")) {
            this.debugging = BooleanLoader.load(values, this).get(0);
        } else if (name.equalsIgnoreCase("debugPort")) {
            this.debugPort = IntegerLoader.load(values, this).get(0);
        } else if (name.equalsIgnoreCase("consul")) {
            this.consul = NodeLoader.load(values, ServerConsul.class, this).get(0);
        }
    }

    @Override
    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("identifier")) {
            this.identifier = (String)values.get(0);
        } else if (name.equalsIgnoreCase("vcs")) {
            this.vcs = (String)values.get(0);
        } else if (name.equalsIgnoreCase("started")) {
            this.started = (Boolean)values.get(0);
        } else if (name.equalsIgnoreCase("debugging")) {
            this.debugging = (Boolean)values.get(0);
        } else if (name.equalsIgnoreCase("debugPort")) {
            this.debugPort = (Integer)values.get(0);
        } else if (name.equalsIgnoreCase("consul")) {
            this.consul = values.get(0) != null ? this.core$().graph().load(((Layer)values.get(0)).core$().id()).as(ServerConsul.class) : null;
        }
    }

    @Override
    public Create create() {
        return new Create(null);
    }

    @Override
    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    @Override
    public CesarGraph graph() {
        return this.core$().graph().as(CesarGraph.class);
    }

    public static abstract class AbstractRegistry
    extends Layer
    implements Terminal {
        protected URL log;

        public AbstractRegistry(Node node) {
            super(node);
        }

        public URL log() {
            return this.log;
        }

        public Process.Registry log(URL url, String destination) {
            this.log = url == null ? null : this.graph().core$().save(url, destination, this.log, this.core$());
            return (Process.Registry)this;
        }

        public Process.Registry log(InputStream stream, String destination) {
            this.log = stream == null ? null : this.graph().core$().save(stream, destination, this.log, this.core$());
            return (Process.Registry)this;
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("log", new ArrayList<URL>(Collections.singletonList(this.log)));
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("log")) {
                this.log = ResourceLoader.load(values, this).get(0);
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("log")) {
                this.log = (URL)values.get(0);
            }
        }

        public CesarGraph graph() {
            return this.core$().graph().as(CesarGraph.class);
        }
    }

    public static abstract class AbstractOperations
    extends Layer
    implements Terminal {
        protected int port;
        protected List<Operation> operationList = new ArrayList<Operation>();

        public AbstractOperations(Node node) {
            super(node);
        }

        public int port() {
            return this.port;
        }

        public Process.Operations port(int value) {
            this.port = value;
            return (Process.Operations)this;
        }

        public List<Operation> operationList() {
            return Collections.unmodifiableList(this.operationList);
        }

        public Operation operation(int index) {
            return this.operationList.get(index);
        }

        public List<Operation> operationList(Predicate<Operation> predicate) {
            return this.operationList().stream().filter(predicate).collect(Collectors.toList());
        }

        public Operation operation(Predicate<Operation> predicate) {
            return this.operationList().stream().filter(predicate).findFirst().orElse(null);
        }

        @Override
        protected List<Node> componentList$() {
            LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
            new ArrayList<Operation>(this.operationList).forEach(c -> components.add(c.core$()));
            return new ArrayList<Node>(components);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("port", new ArrayList<Integer>(Collections.singletonList(this.port)));
            return map;
        }

        @Override
        protected void addNode$(Node node) {
            super.addNode$(node);
            if (node.is("Operation")) {
                this.operationList.add(node.as(Operation.class));
            }
        }

        @Override
        protected void removeNode$(Node node) {
            super.removeNode$(node);
            if (node.is("Operation")) {
                this.operationList.remove(node.as(Operation.class));
            }
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("port")) {
                this.port = IntegerLoader.load(values, this).get(0);
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("port")) {
                this.port = (Integer)values.get(0);
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public CesarGraph graph() {
            return this.core$().graph().as(CesarGraph.class);
        }

        public class Clear {
            public void operation(Predicate<Operation> filter) {
                new ArrayList<Operation>(AbstractOperations.this.operationList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Operation operation(String name, List<String> parameters, String description) {
                Operation newElement = AbstractOperations.this.core$().graph().concept(Operation.class).createNode(this.name, AbstractOperations.this.core$()).as(Operation.class);
                newElement.core$().set(newElement, "name", Collections.singletonList(name));
                newElement.core$().set(newElement, "parameters", parameters);
                newElement.core$().set(newElement, "description", Collections.singletonList(description));
                return newElement;
            }
        }
    }

    public static abstract class AbstractDeployment
    extends Layer
    implements Terminal {
        protected Instant created;
        protected String vcsCommit;
        protected String jvmOptions;
        protected boolean success;
        protected Artifact artifact;
        protected Process.Deployment.Prerequisites prerequisites;
        protected List<Process.Deployment.Parameter> parameterList = new ArrayList<Process.Deployment.Parameter>();

        public AbstractDeployment(Node node) {
            super(node);
        }

        public Instant created() {
            return this.created;
        }

        public String vcsCommit() {
            return this.vcsCommit;
        }

        public String jvmOptions() {
            return this.jvmOptions;
        }

        public boolean success() {
            return this.success;
        }

        public Process.Deployment created(Instant value) {
            this.created = value;
            return (Process.Deployment)this;
        }

        public Process.Deployment vcsCommit(String value) {
            this.vcsCommit = value;
            return (Process.Deployment)this;
        }

        public Process.Deployment jvmOptions(String value) {
            this.jvmOptions = value;
            return (Process.Deployment)this;
        }

        public Process.Deployment success(boolean value) {
            this.success = value;
            return (Process.Deployment)this;
        }

        public Artifact artifact() {
            return this.artifact;
        }

        public Process.Deployment.Prerequisites prerequisites() {
            return this.prerequisites;
        }

        public List<Process.Deployment.Parameter> parameterList() {
            return Collections.unmodifiableList(this.parameterList);
        }

        public Process.Deployment.Parameter parameter(int index) {
            return this.parameterList.get(index);
        }

        public List<Process.Deployment.Parameter> parameterList(Predicate<Process.Deployment.Parameter> predicate) {
            return this.parameterList().stream().filter(predicate).collect(Collectors.toList());
        }

        public Process.Deployment.Parameter parameter(Predicate<Process.Deployment.Parameter> predicate) {
            return this.parameterList().stream().filter(predicate).findFirst().orElse(null);
        }

        @Override
        protected List<Node> componentList$() {
            LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
            if (this.artifact != null) {
                components.add(this.artifact.core$());
            }
            if (this.prerequisites != null) {
                components.add(this.prerequisites.core$());
            }
            new ArrayList<Process.Deployment.Parameter>(this.parameterList).forEach(c -> components.add(c.core$()));
            return new ArrayList<Node>(components);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("created", new ArrayList<Instant>(Collections.singletonList(this.created)));
            map.put("vcsCommit", new ArrayList<String>(Collections.singletonList(this.vcsCommit)));
            map.put("jvmOptions", new ArrayList<String>(Collections.singletonList(this.jvmOptions)));
            map.put("success", new ArrayList<Boolean>(Collections.singletonList(this.success)));
            return map;
        }

        @Override
        protected void addNode$(Node node) {
            super.addNode$(node);
            if (node.is("Artifact")) {
                this.artifact = node.as(Artifact.class);
            }
            if (node.is("Process$Deployment$Prerequisites")) {
                this.prerequisites = node.as(Process.Deployment.Prerequisites.class);
            }
            if (node.is("Process$Deployment$Parameter")) {
                this.parameterList.add(node.as(Process.Deployment.Parameter.class));
            }
        }

        @Override
        protected void removeNode$(Node node) {
            super.removeNode$(node);
            if (node.is("Artifact")) {
                this.artifact = null;
            }
            if (node.is("Process$Deployment$Prerequisites")) {
                this.prerequisites = null;
            }
            if (node.is("Process$Deployment$Parameter")) {
                this.parameterList.remove(node.as(Process.Deployment.Parameter.class));
            }
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("created")) {
                this.created = InstantLoader.load(values, this).get(0);
            } else if (name.equalsIgnoreCase("vcsCommit")) {
                this.vcsCommit = StringLoader.load(values, this).get(0);
            } else if (name.equalsIgnoreCase("jvmOptions")) {
                this.jvmOptions = StringLoader.load(values, this).get(0);
            } else if (name.equalsIgnoreCase("success")) {
                this.success = BooleanLoader.load(values, this).get(0);
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("created")) {
                this.created = (Instant)values.get(0);
            } else if (name.equalsIgnoreCase("vcsCommit")) {
                this.vcsCommit = (String)values.get(0);
            } else if (name.equalsIgnoreCase("jvmOptions")) {
                this.jvmOptions = (String)values.get(0);
            } else if (name.equalsIgnoreCase("success")) {
                this.success = (Boolean)values.get(0);
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public CesarGraph graph() {
            return this.core$().graph().as(CesarGraph.class);
        }

        public static abstract class AbstractParameter
        extends Layer
        implements Terminal {
            protected String name;
            protected String value;

            public AbstractParameter(Node node) {
                super(node);
            }

            public String name() {
                return this.name;
            }

            public String value() {
                return this.value;
            }

            public Process.Deployment.Parameter name(String value) {
                this.name = value;
                return (Process.Deployment.Parameter)this;
            }

            public Process.Deployment.Parameter value(String value) {
                this.value = value;
                return (Process.Deployment.Parameter)this;
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("name", new ArrayList<String>(Collections.singletonList(this.name)));
                map.put("value", new ArrayList<String>(Collections.singletonList(this.value)));
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("name")) {
                    this.name = StringLoader.load(values, this).get(0);
                } else if (name.equalsIgnoreCase("value")) {
                    this.value = StringLoader.load(values, this).get(0);
                }
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("name")) {
                    this.name = (String)values.get(0);
                } else if (name.equalsIgnoreCase("value")) {
                    this.value = (String)values.get(0);
                }
            }

            public CesarGraph graph() {
                return this.core$().graph().as(CesarGraph.class);
            }
        }

        public static abstract class AbstractPrerequisites
        extends Layer
        implements Terminal {
            protected int minMemory;
            protected int maxMemory;
            protected double hdd;
            protected Performance performance;
            protected List<Process.Deployment.Prerequisites.SyncDirectoryToServer> syncDirectoryToServerList = new ArrayList<Process.Deployment.Prerequisites.SyncDirectoryToServer>();

            public AbstractPrerequisites(Node node) {
                super(node);
            }

            public int minMemory() {
                return this.minMemory;
            }

            public int maxMemory() {
                return this.maxMemory;
            }

            public double hdd() {
                return this.hdd;
            }

            public Performance performance() {
                return this.performance;
            }

            public Process.Deployment.Prerequisites minMemory(int value) {
                this.minMemory = value;
                return (Process.Deployment.Prerequisites)this;
            }

            public Process.Deployment.Prerequisites maxMemory(int value) {
                this.maxMemory = value;
                return (Process.Deployment.Prerequisites)this;
            }

            public Process.Deployment.Prerequisites hdd(double value) {
                this.hdd = value;
                return (Process.Deployment.Prerequisites)this;
            }

            public Process.Deployment.Prerequisites performance(Performance value) {
                this.performance = value;
                return (Process.Deployment.Prerequisites)this;
            }

            public List<Process.Deployment.Prerequisites.SyncDirectoryToServer> syncDirectoryToServerList() {
                return Collections.unmodifiableList(this.syncDirectoryToServerList);
            }

            public Process.Deployment.Prerequisites.SyncDirectoryToServer syncDirectoryToServer(int index) {
                return this.syncDirectoryToServerList.get(index);
            }

            public List<Process.Deployment.Prerequisites.SyncDirectoryToServer> syncDirectoryToServerList(Predicate<Process.Deployment.Prerequisites.SyncDirectoryToServer> predicate) {
                return this.syncDirectoryToServerList().stream().filter(predicate).collect(Collectors.toList());
            }

            public Process.Deployment.Prerequisites.SyncDirectoryToServer syncDirectoryToServer(Predicate<Process.Deployment.Prerequisites.SyncDirectoryToServer> predicate) {
                return this.syncDirectoryToServerList().stream().filter(predicate).findFirst().orElse(null);
            }

            @Override
            protected List<Node> componentList$() {
                LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
                new ArrayList<Process.Deployment.Prerequisites.SyncDirectoryToServer>(this.syncDirectoryToServerList).forEach(c -> components.add(c.core$()));
                return new ArrayList<Node>(components);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("minMemory", new ArrayList<Integer>(Collections.singletonList(this.minMemory)));
                map.put("maxMemory", new ArrayList<Integer>(Collections.singletonList(this.maxMemory)));
                map.put("hdd", new ArrayList<Double>(Collections.singletonList(this.hdd)));
                map.put("performance", new ArrayList<Performance>(Collections.singletonList(this.performance)));
                return map;
            }

            @Override
            protected void addNode$(Node node) {
                super.addNode$(node);
                if (node.is("Process$Deployment$Prerequisites$SyncDirectoryToServer")) {
                    this.syncDirectoryToServerList.add(node.as(Process.Deployment.Prerequisites.SyncDirectoryToServer.class));
                }
            }

            @Override
            protected void removeNode$(Node node) {
                super.removeNode$(node);
                if (node.is("Process$Deployment$Prerequisites$SyncDirectoryToServer")) {
                    this.syncDirectoryToServerList.remove(node.as(Process.Deployment.Prerequisites.SyncDirectoryToServer.class));
                }
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("minMemory")) {
                    this.minMemory = IntegerLoader.load(values, this).get(0);
                } else if (name.equalsIgnoreCase("maxMemory")) {
                    this.maxMemory = IntegerLoader.load(values, this).get(0);
                } else if (name.equalsIgnoreCase("hdd")) {
                    this.hdd = DoubleLoader.load(values, this).get(0);
                } else if (name.equalsIgnoreCase("performance")) {
                    this.performance = WordLoader.load(values, Performance.class, this).get(0);
                }
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("minMemory")) {
                    this.minMemory = (Integer)values.get(0);
                } else if (name.equalsIgnoreCase("maxMemory")) {
                    this.maxMemory = (Integer)values.get(0);
                } else if (name.equalsIgnoreCase("hdd")) {
                    this.hdd = (Double)values.get(0);
                } else if (name.equalsIgnoreCase("performance")) {
                    this.performance = (Performance)((Object)values.get(0));
                }
            }

            public Create create() {
                return new Create(null);
            }

            public Create create(String name) {
                return new Create(name);
            }

            public Clear clear() {
                return new Clear();
            }

            public CesarGraph graph() {
                return this.core$().graph().as(CesarGraph.class);
            }

            public static abstract class AbstractSyncDirectoryToServer
            extends Layer
            implements Terminal {
                protected String directory;
                protected List<String> targetServers = new ArrayList<String>();

                public AbstractSyncDirectoryToServer(Node node) {
                    super(node);
                }

                public String directory() {
                    return this.directory;
                }

                public List<String> targetServers() {
                    return this.targetServers;
                }

                public String targetServers(int index) {
                    return this.targetServers.get(index);
                }

                public List<String> targetServers(Predicate<String> predicate) {
                    return this.targetServers().stream().filter(predicate).collect(Collectors.toList());
                }

                public Process.Deployment.Prerequisites.SyncDirectoryToServer directory(String value) {
                    this.directory = value;
                    return (Process.Deployment.Prerequisites.SyncDirectoryToServer)this;
                }

                @Override
                protected Map<String, List<?>> variables$() {
                    LinkedHashMap map = new LinkedHashMap();
                    map.put("directory", new ArrayList<String>(Collections.singletonList(this.directory)));
                    map.put("targetServers", this.targetServers);
                    return map;
                }

                @Override
                protected void load$(String name, List<?> values) {
                    super.load$(name, values);
                    if (name.equalsIgnoreCase("directory")) {
                        this.directory = StringLoader.load(values, this).get(0);
                    } else if (name.equalsIgnoreCase("targetServers")) {
                        this.targetServers = StringLoader.load(values, this);
                    }
                }

                @Override
                protected void set$(String name, List<?> values) {
                    super.set$(name, values);
                    if (name.equalsIgnoreCase("directory")) {
                        this.directory = (String)values.get(0);
                    } else if (name.equalsIgnoreCase("targetServers")) {
                        this.targetServers = new ArrayList(values);
                    }
                }

                public CesarGraph graph() {
                    return this.core$().graph().as(CesarGraph.class);
                }
            }

            public class Clear {
                public void syncDirectoryToServer(Predicate<Process.Deployment.Prerequisites.SyncDirectoryToServer> filter) {
                    new ArrayList<Process.Deployment.Prerequisites.SyncDirectoryToServer>(AbstractPrerequisites.this.syncDirectoryToServerList()).stream().filter(filter).forEach(Layer::delete$);
                }
            }

            public class Create {
                protected final String name;

                public Create(String name) {
                    this.name = name;
                }

                public Process.Deployment.Prerequisites.SyncDirectoryToServer syncDirectoryToServer(String directory, List<String> targetServers) {
                    Process.Deployment.Prerequisites.SyncDirectoryToServer newElement = AbstractPrerequisites.this.core$().graph().concept(Process.Deployment.Prerequisites.SyncDirectoryToServer.class).createNode(this.name, AbstractPrerequisites.this.core$()).as(Process.Deployment.Prerequisites.SyncDirectoryToServer.class);
                    newElement.core$().set(newElement, "directory", Collections.singletonList(directory));
                    newElement.core$().set(newElement, "targetServers", targetServers);
                    return newElement;
                }
            }

            public static enum Performance {
                High,
                Medium,
                Low;

            }
        }

        public class Clear {
            public void parameter(Predicate<Process.Deployment.Parameter> filter) {
                new ArrayList<Process.Deployment.Parameter>(AbstractDeployment.this.parameterList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Artifact artifact(String group, String artifactId, String version) {
                Artifact newElement = AbstractDeployment.this.core$().graph().concept(Artifact.class).createNode(this.name, AbstractDeployment.this.core$()).as(Artifact.class);
                newElement.core$().set(newElement, "group", Collections.singletonList(group));
                newElement.core$().set(newElement, "artifactId", Collections.singletonList(artifactId));
                newElement.core$().set(newElement, "version", Collections.singletonList(version));
                return newElement;
            }

            public Process.Deployment.Prerequisites prerequisites() {
                Process.Deployment.Prerequisites newElement = AbstractDeployment.this.core$().graph().concept(Process.Deployment.Prerequisites.class).createNode(this.name, AbstractDeployment.this.core$()).as(Process.Deployment.Prerequisites.class);
                return newElement;
            }

            public Process.Deployment.Parameter parameter(String name, String value) {
                Process.Deployment.Parameter newElement = AbstractDeployment.this.core$().graph().concept(Process.Deployment.Parameter.class).createNode(this.name, AbstractDeployment.this.core$()).as(Process.Deployment.Parameter.class);
                newElement.core$().set(newElement, "name", Collections.singletonList(name));
                newElement.core$().set(newElement, "value", Collections.singletonList(value));
                return newElement;
            }
        }
    }

    public class Clear {
        public void deployment(Predicate<Process.Deployment> filter) {
            new ArrayList<Process.Deployment>(AbstractProcess.this.deploymentList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public class Create
    extends Perceptible.Create {
        public Create(String name) {
            super(name);
        }

        public Process.Deployment deployment(String vcsCommit) {
            Process.Deployment newElement = AbstractProcess.this.core$().graph().concept(Process.Deployment.class).createNode(this.name, AbstractProcess.this.core$()).as(Process.Deployment.class);
            newElement.core$().set(newElement, "vcsCommit", Collections.singletonList(vcsCommit));
            return newElement;
        }

        public Process.Operations operations() {
            Process.Operations newElement = AbstractProcess.this.core$().graph().concept(Process.Operations.class).createNode(this.name, AbstractProcess.this.core$()).as(Process.Operations.class);
            return newElement;
        }

        public Process.Registry registry() {
            Process.Registry newElement = AbstractProcess.this.core$().graph().concept(Process.Registry.class).createNode(this.name, AbstractProcess.this.core$()).as(Process.Registry.class);
            return newElement;
        }
    }
}

