/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.graph;

import io.intino.cesar.graph.CesarGraph;
import io.intino.cesar.graph.Operation;
import io.intino.magritte.framework.Layer;
import io.intino.magritte.framework.Node;
import io.intino.magritte.framework.loaders.StringLoader;
import io.intino.magritte.framework.tags.Component;
import io.intino.magritte.framework.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public abstract class AbstractOperation
extends Layer
implements Component,
Terminal {
    protected String name;
    protected List<String> parameters = new ArrayList<String>();
    protected String description;
    protected String returnType;

    public AbstractOperation(Node node) {
        super(node);
    }

    public String name() {
        return this.name;
    }

    public List<String> parameters() {
        return this.parameters;
    }

    public String parameters(int index) {
        return this.parameters.get(index);
    }

    public List<String> parameters(Predicate<String> predicate) {
        return this.parameters().stream().filter(predicate).collect(Collectors.toList());
    }

    public String description() {
        return this.description;
    }

    public String returnType() {
        return this.returnType;
    }

    public Operation name(String value) {
        this.name = value;
        return (Operation)this;
    }

    public Operation description(String value) {
        this.description = value;
        return (Operation)this;
    }

    public Operation returnType(String value) {
        this.returnType = value;
        return (Operation)this;
    }

    @Override
    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap();
        map.put("name", new ArrayList<String>(Collections.singletonList(this.name)));
        map.put("parameters", this.parameters);
        map.put("description", new ArrayList<String>(Collections.singletonList(this.description)));
        map.put("returnType", new ArrayList<String>(Collections.singletonList(this.returnType)));
        return map;
    }

    @Override
    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("name")) {
            this.name = StringLoader.load(values, this).get(0);
        } else if (name.equalsIgnoreCase("parameters")) {
            this.parameters = StringLoader.load(values, this);
        } else if (name.equalsIgnoreCase("description")) {
            this.description = StringLoader.load(values, this).get(0);
        } else if (name.equalsIgnoreCase("returnType")) {
            this.returnType = StringLoader.load(values, this).get(0);
        }
    }

    @Override
    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("name")) {
            this.name = (String)values.get(0);
        } else if (name.equalsIgnoreCase("parameters")) {
            this.parameters = new ArrayList(values);
        } else if (name.equalsIgnoreCase("description")) {
            this.description = (String)values.get(0);
        } else if (name.equalsIgnoreCase("returnType")) {
            this.returnType = (String)values.get(0);
        }
    }

    public CesarGraph graph() {
        return this.core$().graph().as(CesarGraph.class);
    }
}

