/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.checkers;

import io.intino.cesar.box.CesarBox;
import io.intino.cesar.graph.Server;
import io.intino.cesar.graph.rules.IssueType;

public class ServerChecker {
    private final CesarBox box;
    private final Server server;

    public ServerChecker(Server server, CesarBox box) {
        this.server = server;
        this.box = box;
    }

    public void check() {
        if (this.server.status() == null) {
            return;
        }
        this.checkDisconnected();
        this.checkTemperature();
        this.checkHighCPUConsume();
        this.checkHighMemoryConsume();
        this.checkLimitedHardDisk();
    }

    private void checkTemperature() {
        if (this.server.isHot() && !this.server.currentIssues().contains(IssueType.HighTemperature)) {
            this.addIssue(IssueType.HighTemperature);
        } else if (!this.server.isHot() && this.server.currentIssues().contains(IssueType.HighTemperature)) {
            this.removeIssue(IssueType.HighTemperature);
        }
    }

    private void checkDisconnected() {
        if (this.server.isDisconnected() && !this.server.currentIssues().contains(IssueType.Disconnected)) {
            this.addIssue(IssueType.Disconnected);
        } else if (!this.server.isDisconnected() && this.server.currentIssues().contains(IssueType.Disconnected)) {
            this.removeIssue(IssueType.Disconnected);
        }
    }

    private void checkHighCPUConsume() {
        if (this.server.isCpuFull() && !this.server.currentIssues().contains(IssueType.RunningOutCpu)) {
            this.addIssue(IssueType.RunningOutCpu);
        } else if (!this.server.isCpuFull() && this.server.currentIssues().contains(IssueType.RunningOutCpu)) {
            this.removeIssue(IssueType.RunningOutCpu);
        }
    }

    private void checkHighMemoryConsume() {
    }

    private void checkLimitedHardDisk() {
    }

    private void addIssue(IssueType issueType) {
        this.box.issueDispatcher().onIssue(this.server, issueType);
    }

    private void removeIssue(IssueType issueType) {
        this.box.issueDispatcher().onIssueFinish(this.server, issueType);
    }
}

