/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.checkers;

import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.MessageManager;
import io.intino.cesar.box.accessors.DeviceAccessor;
import io.intino.cesar.box.bot.helpers.ImageHelper;
import io.intino.cesar.box.schemas.CommandExecuted;
import io.intino.cesar.graph.Device;

public class ScreenDownloader {
    private final CesarBox box;

    public ScreenDownloader(CesarBox box) {
        this.box = box;
    }

    public byte[] screenOf(Device device) {
        DeviceAccessor deviceAccessor = this.box.deviceAccessor(device);
        String message = deviceAccessor.captureScreen();
        if (!ScreenDownloader.valid(message)) {
            return null;
        }
        CommandExecuted commandExecuted = ScreenDownloader.executedCommand(message);
        String prefix = "ERROR";
        return !commandExecuted.remarks().startsWith(prefix) ? ImageHelper.decode(commandExecuted.remarks()) : null;
    }

    private static boolean valid(String result) {
        return !result.startsWith("Error");
    }

    public static CommandExecuted executedCommand(String message) {
        return MessageManager.fromMessage(message, CommandExecuted.class);
    }
}

