/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.checkers;

import io.intino.cesar.box.CesarBox;
import io.intino.cesar.graph.Configuration;
import io.intino.cesar.graph.Device;
import io.intino.cesar.graph.rules.IssueType;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.io.IOUtils;

public class DeviceChecker {
    private final CesarBox box;
    private final Configuration configuration;
    private Device device;

    public DeviceChecker(Device device, CesarBox box) {
        this.box = box;
        this.device = device;
        this.configuration = box.graph().configuration();
    }

    public void check() {
        this.checkDisconnected();
        this.checkTemporallyUnavailable();
        if (this.device.currentStatus() != null && this.configuration != null) {
            this.checkUnplug();
            this.checkHighTemperature();
            this.checkDrainingBattery();
            this.checkRunningOutBattery();
            this.checkScreen();
        }
        this.device.save$();
    }

    private void checkDisconnected() {
        if (this.device.isDisconnected() && !this.device.currentIssues().contains(IssueType.Disconnected)) {
            this.addIssue(IssueType.Disconnected);
        } else if (this.device.currentIssues().contains(IssueType.Disconnected) && !this.device.isDisconnected()) {
            this.removeIssue(IssueType.Disconnected);
        }
    }

    private void checkTemporallyUnavailable() {
        if (this.device.isTemporallyUnavailable() && !this.device.currentIssues().contains(IssueType.TemporallyUnavailable)) {
            this.addIssue(IssueType.TemporallyUnavailable);
        } else if (this.device.currentIssues().contains(IssueType.TemporallyUnavailable) && !this.device.isDisconnected()) {
            this.removeIssue(IssueType.TemporallyUnavailable);
        }
    }

    private void checkUnplug() {
        if (this.device.isUnPlugged() && !this.device.currentIssues().contains(IssueType.Unplugged)) {
            this.addIssue(IssueType.Unplugged);
        } else if (this.device.currentIssues().contains(IssueType.Unplugged) && !this.device.isUnPlugged()) {
            this.removeIssue(IssueType.Unplugged);
        }
    }

    private void checkHighTemperature() {
        if (this.device.isHot() && !this.device.currentIssues().contains(IssueType.HighTemperature)) {
            this.addIssue(IssueType.HighTemperature);
        } else if (this.device.currentIssues().contains(IssueType.HighTemperature) && this.device.currentStatus().temperature() < (double)this.configuration.deviceTemperatureThreshold()) {
            this.removeIssue(IssueType.HighTemperature);
        }
    }

    private void checkDrainingBattery() {
        if (this.device.drainingBattery() && !this.device.currentIssues().contains(IssueType.DrainingBattery)) {
            this.addIssue(IssueType.DrainingBattery);
        } else if (this.device.currentIssues().contains(IssueType.DrainingBattery) && this.device.currentStatus().battery() >= (double)this.configuration.deviceDrainingBatteryThreshold()) {
            this.removeIssue(IssueType.DrainingBattery);
        }
    }

    private void checkRunningOutBattery() {
        if (this.device.runningOutBattery() && !this.device.currentIssues().contains(IssueType.RunningOutBattery)) {
            this.addIssue(IssueType.RunningOutBattery);
        } else if (this.device.currentIssues().contains(IssueType.RunningOutBattery) && !this.device.runningOutBattery()) {
            this.removeIssue(IssueType.RunningOutBattery);
        }
    }

    private void checkScreen() {
    }

    private void addIssue(IssueType issueType) {
        if (this.device.activeIssueSensors().contains(issueType)) {
            this.box.issueDispatcher().onIssue(this.device, issueType);
        }
    }

    private void removeIssue(IssueType issueType) {
        this.box.issueDispatcher().onIssueFinish(this.device, issueType);
    }

    private boolean isCorrect() {
        try {
            URL current = this.device.screen().current();
            if (current == null) {
                return true;
            }
            byte[] image = IOUtils.toByteArray(current);
            return true;
        }
        catch (IOException e) {
            return true;
        }
    }
}

