/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.rest.notifications;

import io.intino.alexandria.exceptions.Unauthorized;
import io.intino.alexandria.http.pushservice.Client;
import io.intino.alexandria.http.pushservice.MessageCarrier;
import io.intino.alexandria.http.pushservice.Session;
import io.intino.alexandria.http.spark.SparkContext;
import io.intino.alexandria.http.spark.SparkManager;
import io.intino.alexandria.http.spark.SparkNotifier;
import io.intino.alexandria.http.spark.SparkPushService;
import io.intino.alexandria.http.spark.SparkSession;
import io.intino.alexandria.rest.RequestAdapter;
import io.intino.alexandria.rest.Resource;
import io.intino.alexandria.rest.ResponseAdapter;
import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.actions.BotNotificationsAction;
import java.util.UUID;

public class BotNotificationsNotification
implements Resource {
    private CesarBox box;
    private SparkManager<SparkPushService> manager;

    public BotNotificationsNotification(CesarBox box, SparkManager manager) {
        this.box = box;
        this.manager = manager;
    }

    @Override
    public void execute() throws Unauthorized {
        SparkSession session = this.manager.currentSession();
        String clientId = UUID.randomUUID().toString();
        BotNotificationsAction action = this.fill(new BotNotificationsAction());
        this.manager.pushService().onOpen(client -> {
            action.onOpen((Client)client, this.notifier(session, (Client)client));
            return true;
        });
        this.manager.pushService().onClose(clientId).execute(action::onClose);
        this.write(this.manager.baseUrl().replace("http", "ws") + "/push?id=" + clientId);
    }

    private BotNotificationsAction fill(BotNotificationsAction action) {
        action.box = this.box;
        action.context = this.context();
        action.user = RequestAdapter.adapt(this.manager.fromQuery("user"), String.class);
        return action;
    }

    private void write(String object) {
        this.manager.write(ResponseAdapter.adapt(object), "text/plain");
    }

    private SparkNotifier notifier(Session session, Client client) {
        return new SparkNotifier(new MessageCarrier(this.manager.pushService(), session, client));
    }

    private SparkContext context() {
        SparkContext context = new SparkContext(this.manager);
        context.put("ip", this.manager.ip());
        return context;
    }
}

