/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.infrastructure.mounters.handlers;

import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.MessageManager;
import io.intino.cesar.box.accessors.ServerProcessAccessor;
import io.intino.cesar.box.infrastructure.mounters.handlers.InfrastructureHandler;
import io.intino.cesar.box.schemas.ProcessDeployment;
import io.intino.cesar.datahub.events.Operations;
import io.intino.cesar.datahub.events.cesar.InfrastructureOperation;
import io.intino.cesar.graph.Artifact;
import io.intino.cesar.graph.CesarGraph;
import io.intino.cesar.graph.Process;
import io.intino.cesar.graph.Server;
import io.intino.cesar.graph.ServerConsul;
import io.intino.magritte.framework.Node;
import java.util.List;
import java.util.stream.Collectors;

public class ProcessHandler {
    private static Process load(CesarGraph cesar, String id) {
        Node node = cesar.core$().load(id);
        return node == null ? null : node.as(Process.class);
    }

    public static class ChangeParameter
    extends InfrastructureHandler {
        private final String name = this.parameters().get(0);
        private final String value = this.parameters().get(1);

        public ChangeParameter(CesarBox box, InfrastructureOperation operation) {
            super(box, operation);
        }

        @Override
        public void execute() {
            Process process = ProcessHandler.load(this.cesar, this.objectID());
            if (process == null) {
                return;
            }
            List<Process.Deployment> deployments = process.deploymentList();
            if (deployments.isEmpty()) {
                return;
            }
            Process.Deployment deployment = deployments.get(deployments.size() - 1);
            Process.Deployment.Parameter parameter = deployment.parameterList().stream().filter(p -> p.name().equals(this.name)).findFirst().orElse(null);
            if (parameter == null) {
                return;
            }
            parameter.value(this.value);
            this.notifyConsul(process, parameter);
        }

        private void notifyConsul(Process process, Process.Deployment.Parameter parameter) {
            new Thread(() -> {
                ServerProcessAccessor accessor = this.box.serverProcessAccessor(process);
                if (accessor.parameter(process, parameter.name(), parameter.value()).booleanValue()) {
                    parameter.save$();
                }
            }).start();
        }
    }

    public static class ChangeStatus
    extends InfrastructureHandler {
        public ChangeStatus(CesarBox box, InfrastructureOperation operation) {
            super(box, operation);
        }

        @Override
        public void execute() {
            Process process = ProcessHandler.load(this.cesar, this.objectID());
            if (process == null) {
                return;
            }
            String newStatus = this.infrastructureOperation.parameters().get(0);
            if (newStatus.equals("start")) {
                process.started(true);
                process.debugging(false);
            }
            if (newStatus.equals("stop")) {
                process.started(false);
                process.debugging(false);
            }
            if (newStatus.equals("debug")) {
                process.started(true);
                process.debugging(true);
            }
            if (newStatus.equals("restart")) {
                process.started(true);
                process.debugging(false);
            }
            process.save$();
        }
    }

    public static class NewDeployment
    extends InfrastructureHandler {
        private final ProcessDeployment schema;

        public NewDeployment(CesarBox box, InfrastructureOperation operation) {
            super(box, operation);
            this.schema = MessageManager.gson().fromJson(this.parameters().get(0), ProcessDeployment.class);
        }

        public NewDeployment(CesarBox box, InfrastructureOperation operation, ProcessDeployment schema) {
            super(box, operation);
            this.schema = schema;
        }

        @Override
        public void execute() {
            Process process = this.cesar.process(this.schema.destinationServer(), this.objectID());
            if (process == null) {
                return;
            }
            Process.Deployment deployment = process.create().deployment(this.schema.vcs() != null ? this.schema.vcs().url() : null);
            Artifact artifact = deployment.create().artifact(this.schema.groupId(), this.schema.artifactId(), this.schema.version());
            this.schema.artifactoryList().forEach(artifactory -> artifact.create().artifactory(artifactory.url(), artifactory.id()));
            artifact.classpathPrefix(this.schema.packaging().classpathPrefix());
            Process.Deployment.Prerequisites r = deployment.create().prerequisites();
            if (this.schema.requirements() != null) {
                if (this.schema.requirements().hdd() > 0.0) {
                    r.hdd(this.schema.requirements().hdd());
                }
                if (this.schema.requirements().minMemory() > 0) {
                    r.minMemory(this.schema.requirements().minMemory());
                }
                if (this.schema.requirements().maxMemory() > 0) {
                    r.maxMemory(this.schema.requirements().maxMemory());
                }
            }
            deployment.success(true);
            if (this.schema.packaging() != null) {
                for (ProcessDeployment.Packaging.Parameter newParameter : this.schema.packaging().parameterList()) {
                    deployment.create(newParameter.name()).parameter(newParameter.name(), newParameter.value());
                }
            }
            process.currentIssues().clear();
            process.started(true);
            process.save$();
            new Thread(() -> this.collectOperations(process)).start();
        }

        private void collectOperations(Process process) {
            if (process.operations() == null) {
                process.create().operations();
            }
            process.operations().clear().operation(o -> true);
            List<Operations.Operation> answer = this.box.serverProcessAccessor(process).operations();
            if (answer != null) {
                process.processNewOperations(answer);
            }
            process.save$();
        }
    }

    public static class Rename
    extends InfrastructureHandler {
        public Rename(CesarBox box, InfrastructureOperation operation) {
            super(box, operation);
        }

        @Override
        public void execute() {
            Process process = this.cesar.process(this.parameters().get(0), this.objectID());
            process.label(this.parameters().get(0));
            process.save$();
        }
    }

    public static class Remove
    extends InfrastructureHandler {
        public Remove(CesarBox box, InfrastructureOperation operation) {
            super(box, operation);
        }

        @Override
        public void execute() {
            Process process = this.cesar.core$().load(this.objectID()).as(Process.class);
            if (process.consul() != null) {
                Server server = this.cesar.serverOf(process);
                if (this.box.terminal() != null) {
                    this.box.serverProcessAccessor(process).retract();
                }
                process.consul().processes().remove(process);
                server.releasePort(process.debugPort());
                server.releasePort(process.operations().port());
            }
            process.delete$();
        }
    }

    public static class Add
    extends InfrastructureHandler {
        private final ProcessDeployment schema;

        public Add(CesarBox box, InfrastructureOperation operation) {
            super(box, operation);
            this.schema = MessageManager.gson().fromJson(this.parameters().get(0), ProcessDeployment.class);
        }

        public Add(CesarBox box, InfrastructureOperation infrastructureOperation, ProcessDeployment schema) {
            super(box, infrastructureOperation);
            this.schema = schema;
        }

        @Override
        public void execute() {
            Server server = this.findServer(this.schema.destinationServer());
            if (server == null) {
                return;
            }
            ServerConsul consul = server.serverConsul();
            String artifact = this.schema.groupId() + ":" + this.schema.artifactId();
            if (server.processList().stream().anyMatch(s -> s.identifier().equals(artifact) && s.consul().equals(consul))) {
                return;
            }
            Process newProcess = server.create().process(artifact, artifact, this.schema.vcs() != null ? this.schema.vcs().commit() : null);
            newProcess.create().operations();
            newProcess.operations().port(this.schema.jmxPort());
            newProcess.consul(consul);
            newProcess.debugPort(newProcess.consul().core$().ownerAs(Server.class).reserveDebugPort());
            newProcess.save$();
            new Thread(() -> this.box.serverProcessAccessor(newProcess).status()).start();
        }

        private Server findServer(String serverName) {
            return (Server)this.box.graph().serverList(u -> u.name$().equals(serverName)).collect(Collectors.toList()).get(0);
        }
    }
}

