/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.bot.helpers;

import io.intino.alexandria.logger.Logger;
import io.intino.cesar.graph.Device;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Base64;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;

public class ImageHelper {
    private static final int ROWS = 15;

    public static byte[] decode(String base64) {
        return ImageHelper.bytesOf(base64);
    }

    public static String encode(URL url) {
        try {
            InputStream is = url.openStream();
            byte[] imageBytes = IOUtils.toByteArray(is);
            is.close();
            return Base64.getEncoder().encodeToString(imageBytes);
        }
        catch (IOException e) {
            Logger.error(e);
            return "";
        }
    }

    public static byte[] decodeWithGrid(String base64, Device device) {
        BufferedImage image = ImageHelper.bufferedImageFrom(base64);
        if (image == null) {
            return new byte[0];
        }
        device.screen().height(image.getHeight());
        device.screen().width(image.getWidth());
        return ImageHelper.merge(image, ImageHelper.createGridFor(device));
    }

    public static byte[] decodeWithGrid(byte[] bytes, Device device) {
        BufferedImage image = ImageHelper.bufferedImageFrom(bytes);
        if (image == null) {
            return new byte[0];
        }
        device.screen().height(image.getHeight());
        device.screen().width(image.getWidth());
        return ImageHelper.merge(image, ImageHelper.createGridFor(device));
    }

    public static int pixelXOf(String position, Device device) {
        int size = device.screen().height() / 15;
        int level = Character.toUpperCase(position.charAt(0)) - 65;
        return level * size + size / 2;
    }

    public static int pixelYOf(String position, Device device) {
        int size = device.screen().height() / 15;
        int level = Integer.valueOf(position.substring(1));
        return level * size + size / 2;
    }

    private static byte[] merge(BufferedImage image, BufferedImage gridFor) {
        image.getGraphics().drawImage(gridFor, 0, 0, null);
        return ImageHelper.decodeImage(image);
    }

    public static byte[] decodeImage(BufferedImage image) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, "jpg", stream);
            stream.flush();
            return stream.toByteArray();
        }
        catch (IOException e) {
            Logger.error(e);
            return new byte[0];
        }
    }

    private static BufferedImage createGridFor(Device device) {
        int size = device.screen().height() / 15;
        BufferedImage img = new BufferedImage(device.screen().width(), device.screen().height(), 2);
        Graphics2D g2d = img.createGraphics();
        ImageHelper.transparentRect(device, g2d);
        ImageHelper.drawLines(device, size, g2d);
        ImageHelper.drawStrings(device, size, g2d);
        return img;
    }

    private static void transparentRect(Device device, Graphics2D g2d) {
        g2d.setComposite(AlphaComposite.Clear);
        g2d.fillRect(0, 0, device.screen().width(), device.screen().height());
    }

    private static void drawLines(Device device, int size, Graphics2D g2d) {
        g2d.setComposite(AlphaComposite.Src);
        g2d.setColor(Color.gray);
        BasicStroke bs = new BasicStroke(2.0f);
        g2d.setStroke(bs);
        for (int i = 1; i < 15; ++i) {
            g2d.drawLine(0, i * size, device.screen().width(), i * size);
        }
        for (int rectWidth = size; rectWidth < device.screen().width(); rectWidth += size) {
            g2d.drawLine(rectWidth, 0, rectWidth, device.screen().height());
        }
    }

    private static void drawStrings(Device device, int size, Graphics2D g2d) {
        g2d.setFont(new Font("Verdana", 1, 14));
        g2d.setColor(Color.black);
        int number = 0;
        for (int i = 0; i < 15; ++i) {
            char letter = 'A';
            int rectWidth = 0;
            while (rectWidth < device.screen().width()) {
                g2d.drawString(String.valueOf(letter) + number, rectWidth + size / 2 - 7, i * size + size / 2 + 7);
                rectWidth += size;
                letter = (char)(letter + '\u0001');
            }
            ++number;
        }
    }

    public static BufferedImage withTimeMark(Device.Screen screen, byte[] bytes) {
        BufferedImage image = ImageHelper.bufferedImageFrom(bytes);
        if (image == null) {
            return null;
        }
        screen.height(image.getHeight());
        screen.width(image.getWidth());
        Graphics graphics = image.getGraphics();
        ImageHelper.drawTime(screen, graphics);
        return image;
    }

    private static void drawTime(Device.Screen screen, Graphics graphics) {
        graphics.setFont(new Font("Verdana", 1, 48));
        graphics.setColor(Color.decode("#EC7200"));
        String now = ImageHelper.format(Instant.now());
        graphics.drawString(now, screen.width() - 350, screen.height() - 50);
        graphics.dispose();
    }

    private static String format(Instant instant) {
        return DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT).withZone(ZoneId.of("UTC")).format(instant) + " UTC";
    }

    private static BufferedImage bufferedImageFrom(String base64) {
        return ImageHelper.bufferedImageFrom(ImageHelper.bytesOf(base64));
    }

    private static BufferedImage bufferedImageFrom(byte[] bytes) {
        try {
            return ImageIO.read(new ByteArrayInputStream(bytes));
        }
        catch (IOException e) {
            Logger.error(e);
            return null;
        }
    }

    private static byte[] bytesOf(String base64) {
        return io.intino.alexandria.Base64.decode(base64);
    }
}

