/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.bot.helpers;

import io.intino.cesar.box.schemas.DeviceStatus;
import io.intino.cesar.datahub.events.consul.server.ServerStatus;
import io.intino.cesar.graph.Device;
import io.intino.cesar.graph.Process;
import io.intino.cesar.graph.ProcessStatus;
import io.intino.cesar.graph.Server;
import java.text.DecimalFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;

public class BotMessageFormatter {
    private static final String NO_STATUS = "no status";
    private static final DecimalFormat df = new DecimalFormat("0.0#");

    public static String format(Device device, String timeZone) {
        io.intino.cesar.graph.DeviceStatus status = device.currentStatus();
        return status == null ? NO_STATUS : ":battery:`" + df.format(status.battery()) + "`   :electric_plug:`" + BotMessageFormatter.state(status.isPlugged()) + "`   :thermometer:`" + df.format(status.temperature()) + "`   :cpu:`" + df.format(status.cpuUsage()) + "`   :desktop_computer:`" + BotMessageFormatter.state(status.isScreenOn()) + "`   " + BotMessageFormatter.time(status.ts(), timeZone, device.isDisconnected());
    }

    public static String format(DeviceStatus status, String timeZone) {
        return status == null ? NO_STATUS : ":battery:`" + df.format(status.battery()) + "`   :electric_plug:`" + BotMessageFormatter.state(status.isPlugged()) + "`   :thermometer:`" + df.format(status.temperature()) + "`   :cpu:`" + df.format(status.cpuUsage()) + "`   :desktop_computer:`" + BotMessageFormatter.state(status.isScreenOn()) + "`   " + BotMessageFormatter.time(status.ts() == null ? Instant.now() : status.ts(), timeZone);
    }

    public static String format(Server server, String timeZone) {
        io.intino.cesar.graph.ServerStatus status = server.currentStatus();
        StringBuilder builder = new StringBuilder();
        builder.append("> ");
        if (status == null) {
            return builder.append(NO_STATUS).toString();
        }
        if (server.isDisconnected()) {
            return BotMessageFormatter.formatDisconnected(builder, status.ts(), timeZone).toString();
        }
        builder.append(BotMessageFormatter.cpu(status.cpuUsage()));
        builder.append("   ").append(BotMessageFormatter.memory(status.memoryUsage())).append("   ").append(BotMessageFormatter.hdd(status.diskUsage()));
        if (status.kernelTemperature() > 0.0) {
            builder.append("   ").append(BotMessageFormatter.temperature(status.kernelTemperature(), status.externalTemperature()));
        }
        builder.append("   ").append(BotMessageFormatter.connections(status.inboundConnections(), status.outboundConnections())).append("   ").append(BotMessageFormatter.time(status.ts(), timeZone, server.isDisconnected()));
        return builder.toString();
    }

    public static String format(io.intino.cesar.graph.ServerStatus status, String timeZone) {
        StringBuilder builder = new StringBuilder();
        builder.append("> ");
        if (status == null) {
            return builder.append(NO_STATUS).toString();
        }
        builder.append("\n\t").append("   ").append(BotMessageFormatter.cpu(status.cpuUsage())).append("   ").append(BotMessageFormatter.memory(status.memoryUsage())).append("   ").append(BotMessageFormatter.hdd(status.diskUsage()));
        if (status.kernelTemperature() > 0.0) {
            builder.append("   ").append(BotMessageFormatter.temperature(status.kernelTemperature(), status.externalTemperature()));
        }
        builder.append("   ").append(BotMessageFormatter.connections(status.inboundConnections(), status.outboundConnections())).append("   ").append(BotMessageFormatter.time(status.ts(), timeZone));
        return builder.toString();
    }

    public static String format(ServerStatus status, String timeZone) {
        StringBuilder builder = new StringBuilder();
        if (status == null) {
            return builder.append(NO_STATUS).toString();
        }
        builder.append(" ").append(BotMessageFormatter.cpu(status.cpu())).append("   ").append(BotMessageFormatter.memory(status.memory())).append("   ").append(BotMessageFormatter.hdd(status.hdd()));
        if (status.kernelTemperature() > 0.0) {
            builder.append("   ").append(BotMessageFormatter.temperature(status.kernelTemperature(), status.temperature()));
        }
        builder.append("   ").append(BotMessageFormatter.connections(status.inboundConnections(), status.outboundConnections())).append("   ").append(BotMessageFormatter.time(status.ts(), timeZone));
        return builder.toString();
    }

    private static String time(Instant instant, String timeZone, boolean disconnected) {
        return (disconnected ? ":disconnected:" : ":clock10:") + "`" + BotMessageFormatter.formatInstant(instant, timeZone) + "`";
    }

    private static String time(Instant instant, String timeZone) {
        return ":clock10:`" + BotMessageFormatter.formatInstant(instant, timeZone) + "`";
    }

    public static String format(io.intino.cesar.datahub.events.consul.process.ProcessStatus status, Process process, String timeZone) {
        String result = " ";
        if (status == null || !status.running().booleanValue()) {
            return result + "process is not running";
        }
        double assigned = process.currentDeployment().prerequisites().maxMemory();
        if (assigned == 0.0) {
            assigned = process.deployedServer().memory().capacity() / 4.0;
        }
        return result + BotMessageFormatter.cpu(status.cpu()) + " " + BotMessageFormatter.memoryUsed(status.memory(), assigned) + " " + BotMessageFormatter.hddUsed(status.workspaceSize(), status.workspaceTotalSize()) + " " + BotMessageFormatter.threads(status.threads()) + " " + BotMessageFormatter.time(status.ts(), timeZone);
    }

    public static String format(Process process, String timeZone) {
        String result = " ";
        ProcessStatus status = process.currentStatus();
        if (status == null) {
            return result + "process is not running";
        }
        double assigned = process.currentDeployment().prerequisites().maxMemory();
        if (assigned == 0.0) {
            assigned = process.deployedServer().memory().capacity() / 4.0;
        }
        return result + BotMessageFormatter.cpu(status.cpuUsage()) + " " + BotMessageFormatter.memoryUsed(status.memoryUsage(), assigned) + " " + BotMessageFormatter.hddUsed(status.workingDirectorySize(), status.workingDirectoryTotalSize()) + " " + BotMessageFormatter.threads(status.threads()) + " " + BotMessageFormatter.time(status.ts(), timeZone);
    }

    public static String formatCompromised(Device device, String timeZone) {
        io.intino.cesar.graph.DeviceStatus status = device.currentStatus();
        DecimalFormat df = new DecimalFormat("0.0#");
        StringBuilder builder = new StringBuilder();
        if (device.status() == null) {
            return BotMessageFormatter.noData(builder).toString();
        }
        if (device.isDisconnected()) {
            return BotMessageFormatter.formatDisconnected(builder, status.ts(), timeZone).toString();
        }
        if (device.drainingBattery()) {
            builder.append(":battery:`").append(df.format(status.battery())).append("`   ");
        }
        if (device.isUnPlugged()) {
            builder.append(":electric_plug:`").append(BotMessageFormatter.state(status.isPlugged())).append("`   ");
        }
        if (device.isHot()) {
            builder.append(":thermometer:`").append(df.format(status.temperature())).append("`   ");
        }
        if (!status.isScreenOn()) {
            builder.append(":desktop_computer:`").append(BotMessageFormatter.state(status.isScreenOn())).append("`   ");
        }
        builder.append(BotMessageFormatter.time(status.ts(), timeZone, device.isDisconnected()));
        return builder.toString();
    }

    public static String formatCompromised(Server server, String timeZone) {
        io.intino.cesar.graph.ServerStatus status = server.currentStatus();
        StringBuilder builder = new StringBuilder();
        if (server.status() == null) {
            return BotMessageFormatter.noData(builder).toString();
        }
        if (server.isDisconnected()) {
            return BotMessageFormatter.formatDisconnected(builder, status.ts(), timeZone).toString();
        }
        if (server.isRunningOutOfMemory()) {
            builder.append(BotMessageFormatter.hdd(status.diskUsage())).append("`   ");
        }
        if (server.isRunningOutOfDisk()) {
            builder.append(BotMessageFormatter.memory(status.memoryUsage())).append("`   ");
        }
        builder.append(BotMessageFormatter.time(status.ts(), timeZone, server.isDisconnected()));
        return builder.toString();
    }

    private static StringBuilder noData(StringBuilder builder) {
        return builder.append("`Disconnected. No data`");
    }

    private static StringBuilder formatDisconnected(StringBuilder builder, Instant ts, String timeZone) {
        return builder.append("\tDisconnected since ").append("`").append(BotMessageFormatter.formatInstant(ts, timeZone)).append("`");
    }

    public static String formatInstant(Instant instant, String timeZone) {
        return DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss").withZone(ZoneId.of(timeZone)).format(instant);
    }

    public static String shortFormatInstant(Instant instant, String timeZone) {
        return DateTimeFormatter.ofPattern("dd/MM HH:mm").withZone(ZoneId.of(timeZone)).format(instant);
    }

    public static String shortTimeInstant(Instant instant, String timeZone) {
        return DateTimeFormatter.ofPattern("HH:mm").withZone(ZoneId.of(timeZone)).format(instant);
    }

    private static String temperature(double kTemperature, double eTemperature) {
        return kTemperature == 0.0 ? "" : ":thermometer:`k:" + df.format(kTemperature) + "\u00ba` " + (String)(eTemperature != 0.0 ? "`e:" + df.format(eTemperature) + "\u00ba`" : "");
    }

    private static String hdd(double value) {
        return ":hdd: " + (String)(value < 0.0 ? "?" : "`" + df.format(value) + "%`");
    }

    private static String hddUsed(double value, double total) {
        return ":hdd: `" + BotMessageFormatter.format(Double.parseDouble(df.format(value)), "Mb", "Gb") + "/" + BotMessageFormatter.format(Double.parseDouble(df.format(total)), "Mb", "Gb") + "`";
    }

    private static String memory(double value) {
        return ":memory: `" + df.format(value) + "%`";
    }

    private static String memoryUsed(double value, double assigned) {
        return ":memory: `" + BotMessageFormatter.format(Double.parseDouble(df.format(value)), "Mb", "Gb") + "/" + BotMessageFormatter.format(Double.parseDouble(df.format(assigned)), "Mb", "Gb") + "`";
    }

    private static String format(double value, String metric, String superMetric) {
        return value > 2000.0 ? df.format(value / 1024.0) + superMetric : value + metric;
    }

    private static String connections(int in, int out) {
        return ":network: (`" + BotMessageFormatter.format(in, "Mb", "Gb") + "`:small_red_triangle_down: `" + BotMessageFormatter.format(out, "Mb", "Gb") + "`:small_red_triangle:)";
    }

    private static String cpu(double value) {
        return ":cpu: " + (String)(value < 0.0 ? "?" : "`" + df.format(value * 100.0) + "%`");
    }

    private static String threads(int value) {
        return ":threads: `" + value + "`";
    }

    private static String state(boolean state) {
        return state ? "ON" : "OFF";
    }
}

