/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.accessors;

import com.google.gson.Gson;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.terminal.Connector;
import io.intino.alexandria.terminal.JmsConnector;
import io.intino.cesar.box.schemas.Command;
import io.intino.cesar.graph.Device;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;

public class DeviceAccessor {
    private final String deviceId;
    private final Connector connector;

    public DeviceAccessor(Connector connector, Device device) {
        this.connector = connector;
        this.deviceId = device.name$();
    }

    public String status() {
        return this.sendCommand("status", Collections.emptyMap());
    }

    public String captureScreen() {
        return this.sendCommand("capturescreen", Collections.emptyMap());
    }

    public String screenOn() {
        return this.sendCommand("screenon", Collections.emptyMap());
    }

    public String screenOff() {
        return this.sendCommand("screenoff", Collections.emptyMap());
    }

    public String tap(final int x, final int y) {
        return this.sendCommand("tap", (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("x", String.valueOf(x));
                this.put("y", String.valueOf(y));
            }
        });
    }

    public String killTask(final String packageName) {
        return this.sendCommand("killtask", (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("package", packageName);
            }
        });
    }

    public String launchTask(final String packageName) {
        return this.sendCommand("launchtask", (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("package", packageName);
            }
        });
    }

    public String deleteAPP(final String packageName) {
        return this.sendCommand("deleteapk", (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("package", packageName);
            }
        });
    }

    public String installAPP(final String url) {
        return this.sendCommand("installapk", (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("url", url);
            }
        });
    }

    public String updateAPP(final String url) {
        return this.sendCommand("updateapk", (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("url", url);
            }
        });
    }

    public String reboot() {
        return this.sendCommand("reboot", new HashMap<String, String>());
    }

    public String drag(final int x1, final int y1, final int x2, final int y2) {
        return this.sendCommand("scroll", (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("x1", String.valueOf(x1));
                this.put("y1", String.valueOf(y1));
                this.put("x2", String.valueOf(x2));
                this.put("y2", String.valueOf(y2));
            }
        });
    }

    public String execute(String[] args) {
        return this.sendCommand(args[0], this.mapFrom(args));
    }

    private Map<String, String> mapFrom(String[] args) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 1; i < args.length; i += 2) {
            map.put(args[i], args[i + 1]);
        }
        return map;
    }

    private String sendCommand(String commandName, Map<String, String> parameters) {
        Session session = ((JmsConnector)this.connector).session();
        try {
            Thread thread = Thread.currentThread();
            String[] result = new String[]{"Error: no answer"};
            if (session == null) {
                return result[0];
            }
            MessageConsumer consumer = session.createConsumer(session.createTopic("service.consul." + this.deviceId + ".reply"));
            consumer.setMessageListener(message -> {
                result[0] = this.textFrom(message);
                thread.interrupt();
            });
            MessageProducer producer = session.createProducer(session.createTopic("service.consul." + this.deviceId));
            producer.send(this.createMessage(commandName, parameters, session));
            producer.close();
            try {
                Thread.sleep((commandName.equalsIgnoreCase("capturescreen") ? 15 : 5) * 1000);
                consumer.close();
                return result[0];
            }
            catch (InterruptedException e) {
                consumer.close();
                return result[0];
            }
        }
        catch (JMSException e) {
            Logger.error(e);
            return "Error: doing request-reply: " + e.getMessage();
        }
    }

    private BytesMessage createMessage(String commandName, Map<String, String> parameters, Session session) throws JMSException {
        BytesMessage message = session.createBytesMessage();
        Command command = new Command().operation(commandName);
        command.parameters().putAll(parameters);
        message.writeBytes(new Gson().toJson(command).getBytes());
        return message;
    }

    private String textFrom(Message message) {
        try {
            if (message instanceof BytesMessage) {
                byte[] data = new byte[(int)((BytesMessage)message).getBodyLength()];
                ((BytesMessage)message).readBytes(data);
                return new String(data);
            }
            return ((TextMessage)message).getText();
        }
        catch (JMSException e) {
            Logger.error(e);
            return "";
        }
    }
}

