/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box;

import com.github.baloise.rocketchatrestclient.RocketChatClient;
import com.github.baloise.rocketchatrestclient.model.Message;
import com.github.baloise.rocketchatrestclient.model.Room;
import com.github.baloise.rocketchatrestclient.model.User;
import io.intino.alexandria.logger.Logger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RocketChat {
    private final RocketChatClient rc;
    private final List<User> users;

    public RocketChat(String url, String user, String password) {
        this.rc = new RocketChatClient(url, user, password);
        this.users = new ArrayList<User>();
        this.loadUsers();
    }

    public void sendToUser(String userName, String message) {
        User user;
        if (this.users.isEmpty()) {
            this.loadUsers();
        }
        if ((user = this.findUserByName(userName)) == null) {
            return;
        }
        this.sendToUser(user, message);
    }

    public void send(String channel, String message) {
        try {
            this.rc.getChatApi().postMessage(new Room(channel, false), new Message(message));
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    private void sendToUser(User user, String message) {
        try {
            this.rc.getChatApi().postMessage(this.roomOf(user), this.messageOf(message));
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    public User findUserByName(String aUser) {
        String user = aUser.startsWith("@") ? aUser.substring(1) : aUser;
        return this.users.stream().filter(u -> u.getUsername().equals(user)).findFirst().orElse(null);
    }

    private void loadUsers() {
        try {
            Collections.addAll(this.users, this.rc.getUsersApi().list());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private Room roomOf(User user) {
        Room room = new Room(user.getUsername(), true);
        room.setId("@" + user.getUsername());
        return room;
    }

    private Message messageOf(String message) {
        return new Message(message);
    }
}

