/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar;

import io.intino.alexandria.logger.Logger;
import io.intino.cesar.box.CesarBox;
import io.intino.cesar.countermeasures.CounterMeasure;
import io.intino.cesar.countermeasures.IssueNotification;
import io.intino.cesar.countermeasures.device.RecoverApplication;
import io.intino.cesar.countermeasures.device.TurnOffScreen;
import io.intino.cesar.graph.Perceptible;
import io.intino.cesar.graph.Process;
import io.intino.cesar.graph.rules.IssueType;
import java.util.Collections;
import java.util.List;

public class IssueDispatcher {
    private final CesarBox box;
    private final CounterMeasureFactory factory;

    public IssueDispatcher(CesarBox box) {
        this.box = box;
        this.factory = new CounterMeasureFactory();
    }

    public void onIssue(Perceptible target, IssueType issueType) {
        Logger.info("Issue of type " + issueType.name() + " detected in " + this.label(target));
        target.currentIssues().add(issueType);
        target.save$();
        this.factory.get(issueType).forEach(c -> new Thread(() -> c.start(target)).start());
    }

    public void onIssue(Perceptible target, IssueType issueType, String attachment) {
        Logger.info("Issue of type " + issueType.name() + " detected on " + this.label(target));
        target.currentIssues().add(issueType);
        target.save$();
        this.factory.get(issueType).forEach(c -> new Thread(() -> c.start(target, attachment)).start());
    }

    private String label(Perceptible target) {
        if (target.i$(Process.class)) {
            return target.label() + " of " + target.a$(Process.class).consul().core$().owner().name();
        }
        return target.label();
    }

    public void onIssueFinish(Perceptible target, IssueType issueType) {
        Logger.info("On issue finish: " + issueType.name() + " in " + this.label(target));
        target.currentIssues().remove(issueType);
        target.save$();
        this.factory.get(issueType).forEach(c -> new Thread(() -> c.stop(target)).start());
    }

    private class CounterMeasureFactory {
        private CounterMeasureFactory() {
        }

        public List<CounterMeasure> get(IssueType issueType) {
            if (issueType.equals(IssueType.Log)) {
                return List.of(this.notification(issueType));
            }
            if (issueType.equals(IssueType.HighTemperature)) {
                return List.of(new TurnOffScreen(IssueDispatcher.this.box), this.notification(issueType));
            }
            if (issueType.equals(IssueType.DrainingBattery)) {
                return List.of(this.notification(issueType));
            }
            if (issueType.equals(IssueType.RunningOutBattery)) {
                return List.of(new TurnOffScreen(IssueDispatcher.this.box), this.notification(issueType));
            }
            if (issueType.equals(IssueType.Misconfigured)) {
                return List.of(new RecoverApplication(IssueDispatcher.this.box), this.notification(issueType));
            }
            if (issueType.equals(IssueType.Unplugged) || issueType.equals(IssueType.Stopped) || issueType.equals(IssueType.RunningOutMemory) || issueType.equals(IssueType.RunningOutCpu) || issueType.equals(IssueType.RunningOutDisk) || issueType.equals(IssueType.TemporallyUnavailable) || issueType.equals(IssueType.Disconnected)) {
                return List.of(this.notification(issueType));
            }
            return Collections.emptyList();
        }

        private IssueNotification notification(IssueType issueType) {
            return new IssueNotification(IssueDispatcher.this.box, issueType);
        }
    }
}

