/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.zet;

import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.zet.ZetReader;
import io.intino.alexandria.zet.ZetStream;
import io.intino.alexandria.zet.io.ZOutputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.stream.Stream;

public class ZetWriter {
    private final OutputStream stream;

    public ZetWriter(File file) {
        file.getParentFile().mkdirs();
        this.stream = this.fileOutputStream(file);
    }

    public ZetWriter(OutputStream stream) {
        this.stream = stream;
    }

    public void write(long ... data) {
        this.write(new ZetReader(data));
    }

    public void write(List<Long> messages) {
        this.write(new ZetReader(messages));
    }

    public void write(Stream<Long> stream) {
        this.write(new ZetReader(stream));
    }

    public void write(ZetStream stream) {
        try (ZOutputStream outputStream = this.zOutputStream();){
            while (stream.hasNext()) {
                outputStream.writeLong(stream.next());
            }
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    private ZOutputStream zOutputStream() {
        return new ZOutputStream(new BufferedOutputStream(this.stream));
    }

    private OutputStream fileOutputStream(File file) {
        try {
            return new FileOutputStream(file);
        }
        catch (IOException e) {
            Logger.error(e);
            return new ByteArrayOutputStream();
        }
    }
}

