/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.mapp;

import io.intino.alexandria.mapp.Mapp;
import io.intino.alexandria.mapp.MappStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class MappBuilder {
    private final Index index = new Index();
    private final Map<String, Integer> map = new HashMap<String, Integer>();

    public MappBuilder() {
    }

    public MappBuilder(MappStream stream) {
        this.put(stream);
    }

    public MappBuilder(List<String> values) {
        values.forEach(this::map);
    }

    public MappBuilder put(long key, String ... value) {
        this.index.put(key, this.map(String.join((CharSequence)"\n", value)));
        return this;
    }

    public MappBuilder put(long[] keys, String ... value) {
        this.put(keys, this.map(String.join((CharSequence)"\n", value)));
        return this;
    }

    public MappBuilder put(long key, List<String> value) {
        this.index.put(key, this.map(String.join((CharSequence)"\n", value)));
        return this;
    }

    public MappBuilder put(long[] keys, List<String> value) {
        this.put(keys, this.map(String.join((CharSequence)"\n", value)));
        return this;
    }

    public MappBuilder put(MappStream stream) {
        while (stream.hasNext()) {
            this.put(stream.next());
        }
        return this;
    }

    public MappBuilder put(MappStream.Item item) {
        this.index.put(item.key(), this.map(String.join((CharSequence)"\n", item.value())));
        return this;
    }

    public MappBuilder remove(long key) {
        this.index.remove(key);
        return this;
    }

    public void save(File file) throws IOException {
        this.save(new FileOutputStream(file));
    }

    private void put(long[] keys, int value) {
        Arrays.stream(keys).forEach(k -> this.index.put(k, value));
    }

    private int map(String object) {
        if (this.map.containsKey(object)) {
            return this.map.get(object);
        }
        this.map.put(object, this.map.size());
        return this.map.size() - 1;
    }

    public void save(OutputStream output) throws IOException {
        this.index.sort();
        DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(output));
        this.write(dos);
        dos.close();
    }

    private void write(DataOutputStream dos) throws IOException {
        dos.writeInt(this.map.size());
        for (String value : this.values()) {
            dos.writeUTF(value);
        }
        dos.writeInt(this.index.size());
        dos.write(new IndexToByteArray(this.index).getByteArray());
    }

    private List<String> values() {
        return this.map.entrySet().stream().sorted(Comparator.comparingInt(Map.Entry::getValue)).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public static class IndexToByteArray {
        private final Mapp.Entry[] data = new Mapp.Entry[256];
        private final Index index;
        private long base = -1L;
        private int count = 0;

        public IndexToByteArray(Index index) {
            this.index = index;
        }

        private byte[] getByteArray() throws IOException {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(stream);
            this.index.ids.forEach(entry -> this.writeEntry(dos, (Mapp.Entry)entry));
            this.writeData(dos);
            dos.close();
            return stream.toByteArray();
        }

        private void writeEntry(DataOutputStream stream, Mapp.Entry entry) {
            this.base(stream, entry.key >> 8);
            if (this.isRepeated((byte)entry.key)) {
                return;
            }
            this.data[this.count++] = entry;
        }

        private boolean isRepeated(byte b) {
            return this.count > 0 && (byte)this.data[this.count - 1].key == b;
        }

        private void base(DataOutputStream stream, long base) {
            try {
                if (this.base == base) {
                    return;
                }
                this.writeData(stream);
                this.writeBase(stream, base);
                this.base = base;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private void writeBase(DataOutputStream stream, long base) throws IOException {
            int level = this.base >= 0L ? this.level(base, this.base) : this.level(base);
            stream.writeByte(level);
            for (int i = level - 1; i >= 0; --i) {
                byte b = (byte)(base >> (i << 3));
                stream.writeByte(b);
            }
        }

        private int level(long base) {
            return base != 0L ? this.level(base >> 8) + 1 : 0;
        }

        private int level(long a, long b) {
            return a != b ? this.level(a >> 8, b >> 8) + 1 : 0;
        }

        private void writeData(DataOutputStream stream) throws IOException {
            if (this.base < 0L) {
                return;
            }
            stream.writeByte(this.count);
            for (int i = 0; i < this.count; ++i) {
                stream.writeByte((byte)this.data[i].key);
                this.writeValue(stream, this.data[i].value);
            }
            this.count = 0;
        }

        private void writeValue(DataOutputStream stream, long value) throws IOException {
            while (value >= 128L) {
                stream.write((byte)(0x80L | value & 0x7FL));
                value >>= 7;
            }
            stream.write((byte)value);
        }
    }

    private static class Index {
        private final Comparator<Mapp.Entry> comparator = Comparator.comparingLong(o -> o.key);
        private final List<Mapp.Entry> ids = new ArrayList<Mapp.Entry>();

        private Index() {
        }

        void put(long key, int value) {
            this.ids.add(new Mapp.Entry(key, value));
        }

        private void sort() {
            this.ids.sort(this.comparator);
        }

        public int size() {
            return this.ids.size();
        }

        public void remove(long key) {
            this.ids.removeAll(this.ids.stream().filter(i -> i.key == key).collect(Collectors.toList()));
        }
    }
}

