/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonPrimitive;
import io.intino.alexandria.Base64;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.time.Instant;
import java.util.Date;

public class Json {
    public static String toString(Object object) {
        return Json.gsonWriter().toJson(object);
    }

    public static <T> T fromString(String text, Class<T> t) {
        return Json.gsonReader().fromJson(text, t);
    }

    public static Gson gsonReader() {
        return new GsonBuilder().registerTypeAdapter((Type)((Object)Instant.class), (json, type1, context) -> Instant.ofEpochMilli(json.getAsJsonPrimitive().getAsLong())).registerTypeAdapter((Type)((Object)Date.class), (json, type1, context) -> new Date(json.getAsJsonPrimitive().getAsLong())).registerTypeAdapter((Type)((Object)InputStream.class), (json, type1, context) -> new ByteArrayInputStream(Base64.decode(json.getAsString()))).create();
    }

    public static Gson gsonWriter() {
        return new GsonBuilder().registerTypeAdapter((Type)((Object)Instant.class), (instant, type, context) -> new JsonPrimitive(instant.toEpochMilli())).registerTypeAdapter((Type)((Object)Date.class), (date, type, context) -> new JsonPrimitive(date.getTime())).registerTypeAdapter((Type)((Object)InputStream.class), (inputStream, type1, jsonDeserializationContext) -> new JsonPrimitive(Base64.encode(Json.toByteArray(inputStream)))).create();
    }

    private static byte[] toByteArray(InputStream is) {
        try {
            int nRead;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[1024];
            while ((nRead = is.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            buffer.flush();
            return buffer.toByteArray();
        }
        catch (IOException e) {
            return new byte[0];
        }
    }
}

