/*
 * Decompiled with CFR 0.152.
 */
package com.github.baloise.rocketchatrestclient;

import com.github.baloise.rocketchatrestclient.RocketChatClientCallBuilder;
import com.github.baloise.rocketchatrestclient.RocketChatClientResponse;
import com.github.baloise.rocketchatrestclient.RocketChatQueryParams;
import com.github.baloise.rocketchatrestclient.RocketChatRestApiV1;
import com.github.baloise.rocketchatrestclient.model.Group;
import com.github.baloise.rocketchatrestclient.model.User;
import com.github.baloise.rocketchatrestclient.requests.RoomAndUserRequest;
import com.github.baloise.rocketchatrestclient.requests.RoomCreateRequest;
import java.io.IOException;

public class RocketChatRestApiV1Groups {
    private static final String ROOM_ID_PARAM_KEY = "roomId";
    private RocketChatClientCallBuilder callBuilder;

    protected RocketChatRestApiV1Groups(RocketChatClientCallBuilder callBuilder) {
        this.callBuilder = callBuilder;
    }

    public void archive(Group group) throws IOException {
        RocketChatClientResponse res = this.callBuilder.buildCall(RocketChatRestApiV1.GroupsArchive, null, group);
        if (!res.isSuccessful()) {
            throw new IOException("The call to archive the Group was unsuccessful: \"" + res.getError() + "\"");
        }
    }

    public void close(Group group) throws IOException {
        RocketChatClientResponse res = this.callBuilder.buildCall(RocketChatRestApiV1.GroupsClose, null, group);
        if (!res.isSuccessful()) {
            throw new IOException("The call to close the Group was unsuccessful: \"" + res.getError() + "\"");
        }
    }

    public Group create(Group group) throws IOException {
        RocketChatClientResponse res = this.callBuilder.buildCall(RocketChatRestApiV1.GroupsCreate, null, new RoomCreateRequest(group.getName(), group.getUsernames()));
        if (!res.isSuccessful()) {
            throw new IOException("The call to create a Group was unsuccessful: \"" + res.getError() + "\"");
        }
        if (!res.hasGroup()) {
            throw new IOException("The response does not contain any group information.");
        }
        return res.getGroup();
    }

    public Group info(String groupId) throws IOException {
        return this.info(new Group(groupId, ""));
    }

    public Group info(Group group) throws IOException {
        RocketChatClientResponse res = this.callBuilder.buildCall(RocketChatRestApiV1.GroupsInfo, new RocketChatQueryParams(ROOM_ID_PARAM_KEY, group.getId()));
        if (!res.isSuccessful()) {
            throw new IOException("The call to get the Group's information was unsuccessful: \"" + res.getError() + "\"");
        }
        if (!res.hasGroup()) {
            throw new IOException("The call to get the Group's information was unsuccessful, failed to return channel data.");
        }
        return res.getGroup();
    }

    public void invite(Group group, User user) throws IOException {
        RocketChatClientResponse res = this.callBuilder.buildCall(RocketChatRestApiV1.GroupsInvite, null, new RoomAndUserRequest(group.getId(), user.getId()));
        if (!res.isSuccessful()) {
            throw new IOException("The call to invite a User to a Group was unsuccessful: \"" + res.getError() + "\"");
        }
    }

    public void kick(Group group, User user) throws IOException {
        RocketChatClientResponse res = this.callBuilder.buildCall(RocketChatRestApiV1.GroupsKick, null, new RoomAndUserRequest(group.getId(), user.getId()));
        if (!res.isSuccessful()) {
            throw new IOException("The call to remove a User from a Group was unsuccessful: \"" + res.getError() + "\"");
        }
    }

    public void leave(Group group) throws IOException {
        RocketChatClientResponse res = this.callBuilder.buildCall(RocketChatRestApiV1.GroupsLeave, null, group);
        if (!res.isSuccessful()) {
            throw new IOException("The call to leave a Group was unsuccessful: \"" + res.getError() + "\"");
        }
    }

    public Group[] list() throws IOException {
        return this.list(new RocketChatQueryParams());
    }

    public Group[] list(RocketChatQueryParams params) throws IOException {
        RocketChatClientResponse res = this.callBuilder.buildCall(RocketChatRestApiV1.GroupsList, params);
        if (!res.isSuccessful()) {
            throw new IOException("The call to get the private Groups was unsuccessful: \"" + res.getError() + "\"");
        }
        if (!res.hasGroups()) {
            throw new IOException("Get Groups failed to retrieve the groups.");
        }
        return res.getGroups();
    }

    public void open(Group group) throws IOException {
        RocketChatClientResponse res = this.callBuilder.buildCall(RocketChatRestApiV1.GroupsOpen, null, group);
        if (!res.isSuccessful()) {
            throw new IOException("The call to open the Group was unsuccessful: \"" + res.getError() + "\"");
        }
    }

    public Group rename(Group group) throws IOException {
        RocketChatClientResponse res = this.callBuilder.buildCall(RocketChatRestApiV1.GroupsRename, null, group);
        if (!res.isSuccessful()) {
            throw new IOException("The call to rename a Group was unsuccessful: \"" + res.getError() + "\"");
        }
        if (!res.hasGroup()) {
            throw new IOException("The call to rename a Group failed to return the group data.");
        }
        return res.getGroup();
    }

    public void unarchive(Group group) throws IOException {
        RocketChatClientResponse res = this.callBuilder.buildCall(RocketChatRestApiV1.GroupsUnarchive, null, group);
        if (!res.isSuccessful()) {
            throw new IOException("The call to unarchive the Group was unsuccessful: \"" + res.getError() + "\"");
        }
    }

    public void addOwner(Group group, User user) throws IOException {
        RocketChatClientResponse res = this.callBuilder.buildCall(RocketChatRestApiV1.GroupsAddOwner, null, new RoomAndUserRequest(group.getId(), user.getId()));
        if (!res.isSuccessful()) {
            throw new IOException("The call to add an owner was unsuccessful: \"" + res.getError() + "\"");
        }
    }
}

