/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.countermeasures.notifications;

import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.NotificationConsumer;
import io.intino.cesar.countermeasures.notifications.Email;
import io.intino.cesar.graph.User;
import java.util.Collections;
import java.util.List;

public class EventNotifier {
    private final CesarBox box;

    public EventNotifier(CesarBox box) {
        this.box = box;
    }

    public void notify(List<User> responsibles, String subject, String message) {
        if (!this.box.graph().configuration().notifications()) {
            return;
        }
        for (User responsible : responsibles) {
            if (responsible == null) continue;
            this.notify(responsible, subject, message);
            if (!responsible.mailNotifications()) continue;
            Email.send(Collections.singletonList(responsible.mail()), subject, message);
        }
    }

    public void notify(User user, String subject, String message) {
        NotificationConsumer consumer;
        if (this.box.chat() != null) {
            this.box.chat().sendToUser(user.name$(), "*" + subject + "*. \n" + this.customizeToChat(message));
        }
        if ((consumer = this.box.notificationSubscribers(user.name$())) != null) {
            consumer.accept(subject + "\n" + message);
        }
    }

    private String customizeToChat(String message) {
        return message.contains("\n") ? "```\n" + message + "\n```" : message;
    }
}

