/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.mounters;

import io.intino.alexandria.event.Event;
import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.infrastructure.mounters.DeviceMounter;
import io.intino.cesar.box.infrastructure.mounters.InfrastructureOperationMounter;
import io.intino.cesar.box.infrastructure.mounters.ProcessMounter;
import io.intino.cesar.box.infrastructure.mounters.ServerMounter;
import io.intino.cesar.box.mounters.Mounter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

public class MounterFactory {
    private Map<String, List<Mounter>> mounters = new HashMap<String, List<Mounter>>();

    public MounterFactory(CesarBox box) {
        this.mounters.put("DeviceStatus", List.of(new DeviceMounter(box)));
        this.mounters.put("DeviceCrash", List.of(new DeviceMounter(box)));
        this.mounters.put("ProcessLog", List.of(new ProcessMounter(box)));
        this.mounters.put("ServerInfo", List.of(new ServerMounter(box)));
        this.mounters.put("ProcessStatus", List.of(new ProcessMounter(box)));
        this.mounters.put("ServerLog", List.of(new ServerMounter(box)));
        this.mounters.put("ProcessOperation", List.of(new InfrastructureOperationMounter(box)));
        this.mounters.put("InfrastructureOperation", List.of(new InfrastructureOperationMounter(box)));
        this.mounters.put("ServerBoot", List.of(new ServerMounter(box)));
        this.mounters.put("DeviceBoot", List.of(new DeviceMounter(box)));
        this.mounters.put("ServerStatus", List.of(new ServerMounter(box)));
    }

    public List<Mounter> mountersOf(Event event) {
        return this.mountersOf(event.toMessage().type());
    }

    public List<Mounter> mountersOf(String eventType) {
        return this.mounters.get(eventType);
    }

    public void handle(Event ... events) {
        Stream.of(events).forEach(event -> {
            List<Mounter> mounters = this.mountersOf((Event)event);
            if (mounters != null) {
                mounters.forEach(m -> m.handle((Event)event));
            }
        });
    }
}

