/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.bot;

import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.bot.DeviceContext;
import io.intino.cesar.box.bot.MainContext;
import io.intino.cesar.box.bot.ManageContext;
import io.intino.cesar.box.bot.RestBot;
import io.intino.cesar.box.bot.ServerContext;
import io.intino.cesar.box.bot.ServerProcessContext;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class CesarBot
extends RestBot {
    private final MainContext mainContext;
    private final ManageContext manageContext;
    private final DeviceContext deviceContext;
    private final ServerContext serverContext;
    private final ServerProcessContext serverProcessContext;

    public CesarBot(CesarBox box) {
        this.mainContext = new MainContext(box);
        this.manageContext = new ManageContext(box);
        this.deviceContext = new DeviceContext(box);
        this.serverContext = new ServerContext(box);
        this.serverProcessContext = new ServerProcessContext(box);
        this.add("help", Collections.emptyList(), Collections.emptyList(), "Show this help", (properties, args) -> {
            Map<String, RestBot.CommandInfo> context = this.commandsInfoByContext(this.contexts().get(properties.username()).command());
            StringBuilder builder = new StringBuilder();
            context.keySet().forEach(c -> builder.append(CesarBot.formatCommand(c, (RestBot.CommandInfo)context.get(c))));
            return builder.toString();
        });
        this.add("exit", Collections.emptyList(), Collections.emptyList(), "Exit from current level", (properties, args) -> {
            RestBot.Context context = this.contexts().get(properties.username());
            if (context != null) {
                String command = context.command();
                String message = command.isEmpty() ? "" : "Exited from " + (command.contains("|") ? command.substring(command.lastIndexOf("|") + 1) : command) + " " + String.join((CharSequence)" ", Arrays.asList(context.getObjects()));
                context.command(command.contains("|") ? command.substring(0, command.lastIndexOf("|")) : "");
                context.objects(context.getObjects().length > 1 ? Arrays.copyOfRange(context.getObjects(), 0, context.getObjects().length - 1) : new String[]{});
                return message;
            }
            return "";
        });
        this.add("where", Collections.emptyList(), Collections.emptyList(), "Shows the current level", (properties, args) -> {
            RestBot.Context context = this.contexts().get(properties.username());
            return context != null ? context : "root";
        });
        this.add("assets", "", Collections.emptyList(), Collections.emptyList(), "Show the list of all units with its last status", (properties, args) -> this.mainContext.assets(properties));
        this.add("devices", "", Collections.emptyList(), Collections.emptyList(), "Show the list of all devices with its last status", (properties, args) -> this.mainContext.devices(properties));
        this.add("devices-id", "", Collections.emptyList(), Collections.emptyList(), "Show the list of all devices with its id", (properties, args) -> this.mainContext.devicesId(properties));
        this.add("servers", "", Collections.emptyList(), Collections.emptyList(), "List of servers", (properties, args) -> this.mainContext.servers(properties));
        this.add("feeders", "", Collections.emptyList(), Collections.emptyList(), "List of feeders", (properties, args) -> this.mainContext.feeders(properties));
        this.add("responsibles", "", Collections.emptyList(), Collections.emptyList(), "Show registered responsibles", (properties, args) -> this.mainContext.responsibles(properties));
        this.add("notifications", "", Collections.singletonList("state"), Collections.emptyList(), "Turn the notifications `on` `off`", (properties, args) -> this.mainContext.notifications(properties, args.length > 0 ? args[0] : ""));
        this.add("issues", "", Collections.emptyList(), Collections.emptyList(), "Show the list of all compromised devices or servers", (properties, args) -> this.mainContext.issues(properties));
        this.add("manage", "", Collections.emptyList(), Arrays.asList("", "", "", "", "", ""), "Administration cesar actions", (properties, args) -> this.mainContext.manage(properties));
        this.add("add-responsible", "manage", Arrays.asList("name", "email", "fullName"), Collections.emptyList(), "Register responsible in the infrastructure. Set `username`, `email` and `fullName`", (properties, args) -> this.manageContext.addResponsible(properties, args.length > 0 ? args[0] : "", args.length > 1 ? args[1] : "", args));
        this.add("remove-responsible", "manage", List.of("user"), Collections.emptyList(), "Remove responsible by username. Will be removed also of all units", (properties, args) -> this.manageContext.removeResponsible(properties, args.length > 0 ? args[0] : ""));
        this.add("add-devices", "manage", Collections.singletonList("devices"), Collections.emptyList(), "Add a device list providing `deviceId` and `name` separated by `;`", (properties, args) -> this.manageContext.addDevices(properties, args));
        this.add("remove-device", "manage", Collections.singletonList("device"), Collections.emptyList(), "Remove a device by either its `deviceId` or `name`", (properties, args) -> this.manageContext.removeDevice(properties, args.length > 0 ? args[0] : ""));
        this.add("remove-server", "manage", Collections.singletonList("name"), Collections.emptyList(), "Removes a server providing its `name`", (properties, args) -> this.manageContext.removeServer(properties, args.length > 0 ? args[0] : ""));
        this.add("device", "", Arrays.asList("deviceId"), Arrays.asList("", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""), "Open a connection with a device by either its `deviceId`, `name` or `position`", (properties, args) -> this.mainContext.device(properties, args.length > 0 ? args[0] : ""));
        this.add("name", "device", Arrays.asList("newName"), Collections.emptyList(), "Rename the label of device -> name `newName`", (properties, args) -> this.deviceContext.name(properties, args.length > 0 ? args[0] : ""));
        this.add("info", "device", Collections.emptyList(), Collections.emptyList(), "Information of the selected device", (properties, args) -> this.deviceContext.info(properties));
        this.add("status", "device", Collections.emptyList(), Collections.emptyList(), "Status of the selected device", (properties, args) -> this.deviceContext.status(properties));
        this.add("reboot", "device", Collections.emptyList(), Collections.emptyList(), "Reboots a device", (properties, args) -> this.deviceContext.reboot(properties));
        this.add("grid", "device", Collections.emptyList(), Collections.emptyList(), "Shows what is on the device's screen including a guide to help the tap", (properties, args) -> this.deviceContext.grid(properties));
        this.add("screen", "device", Arrays.asList("state"), Collections.emptyList(), "Shows what is on the device's screen or turns the device's screen `on` `off`", (properties, args) -> this.deviceContext.screen(properties, args.length > 0 ? args[0] : ""));
        this.add("tap", "device", Arrays.asList("square"), Collections.emptyList(), "Produces a touch event in the given position of grid. Example: tap A5", (properties, args) -> this.deviceContext.tap(properties, args.length > 0 ? args[0] : ""));
        this.add("tap-pixel", "device", Arrays.asList("x", "y"), Collections.emptyList(), "Produces a touch event in the given position X and Y", (properties, args) -> this.deviceContext.tapPixel(properties, args.length > 0 ? Integer.parseInt(args[0]) : 0, args.length > 1 ? Integer.parseInt(args[1]) : 0));
        this.add("drag", "device", Arrays.asList("fromSquare", "toSquare"), Collections.emptyList(), "Produces a drag event from the origin square to destination", (properties, args) -> this.deviceContext.drag(properties, args.length > 0 ? args[0] : "", args.length > 1 ? args[1] : ""));
        this.add("kill", "device", Arrays.asList("packageName"), Collections.emptyList(), "Kill a task in the opened device by providing the `android package`", (properties, args) -> this.deviceContext.kill(properties, args.length > 0 ? args[0] : ""));
        this.add("launch", "device", Arrays.asList("packageName"), Collections.emptyList(), "Launch a task in the opened device by providing the `android package`", (properties, args) -> this.deviceContext.launch(properties, args.length > 0 ? args[0] : ""));
        this.add("uninstall", "device", Arrays.asList("packageName"), Collections.emptyList(), "Uninstall an apk in the opened device by providing the `android package`", (properties, args) -> this.deviceContext.uninstall(properties, args.length > 0 ? args[0] : ""));
        this.add("install", "device", Arrays.asList("url"), Collections.emptyList(), "Install an apk in the opened device by providing the `url` to the file", (properties, args) -> this.deviceContext.install(properties, args.length > 0 ? args[0] : ""));
        this.add("update", "device", Arrays.asList("url"), Collections.emptyList(), "Update an apk in the opened device by providing the `url` to the file", (properties, args) -> this.deviceContext.update(properties, args.length > 0 ? args[0] : ""));
        this.add("execute", "device", Arrays.asList("command"), Collections.emptyList(), "Execute command on the device. Add name value pair after command name", this.deviceContext::execute);
        this.add("responsibles", "device", Collections.emptyList(), Collections.emptyList(), "Show registered responsibles", (properties, args) -> this.deviceContext.responsibles(properties));
        this.add("set-responsibles", "device", Arrays.asList("users"), Collections.emptyList(), "Assign responsibles to this device from registered", this.deviceContext::setResponsibles);
        this.add("set-notifications", "device", Arrays.asList("unplug", "temperature", "battery", "lowBattery", "disconnected"), Collections.emptyList(), "set notifications for `unplug` `temperature` `battery` `lowBattery` `disconnected` as macro on/off specifing all", (properties, args) -> this.deviceContext.setNotifications(properties, args.length > 0 ? args[0] : "", args.length > 1 ? args[1] : "", args.length > 2 ? args[2] : "", args.length > 3 ? args[3] : "", args.length > 4 ? args[4] : ""));
        this.add("server", "", Arrays.asList("name"), Arrays.asList("", "", "", "", "", "", "", "", "", "", "", "", "", "", ""), "Open a connection with a server by either its `name` or `position`", (properties, args) -> this.mainContext.server(properties, args.length > 0 ? args[0] : ""));
        this.add("name", "server", Arrays.asList("newName"), Collections.emptyList(), "Rename the alias of device -> name `newName`", (properties, args) -> this.serverContext.name(properties, args.length > 0 ? args[0] : ""));
        this.add("info", "server", Collections.emptyList(), Collections.emptyList(), "Shows information of this server. OS, memory, hdd...", (properties, args) -> this.serverContext.info(properties));
        this.add("status", "server", Collections.emptyList(), Collections.emptyList(), "Status of the selected server", (properties, args) -> this.serverContext.status(properties));
        this.add("remote-connection", "server", Arrays.asList("url", "port", "user"), Collections.emptyList(), "set/get remote connection", (properties, args) -> this.serverContext.remoteConnection(properties, args.length > 0 ? args[0] : "", args.length > 1 ? Integer.parseInt(args[1]) : 0, args.length > 2 ? args[2] : ""));
        this.add("start-all-processes", "server", Collections.emptyList(), Collections.emptyList(), "Start all processes of the server", (properties, args) -> this.serverContext.startAllProcesses(properties));
        this.add("stop-all-processes", "server", Collections.emptyList(), Collections.emptyList(), "Start all processes of the server", (properties, args) -> this.serverContext.stopAllProcesses(properties));
        this.add("reboot", "server", Collections.emptyList(), Collections.emptyList(), "Reboot the server", (properties, args) -> this.serverContext.reboot(properties));
        this.add("log", "server", Collections.emptyList(), Collections.emptyList(), "Log of the server", (properties, args) -> this.serverContext.log(properties));
        this.add("upgrade-consul", "server", Collections.emptyList(), Collections.emptyList(), "Upgrade consul", (properties, args) -> this.serverContext.upgradeConsul(properties));
        this.add("ssh", "server", Collections.emptyList(), Collections.emptyList(), "Shows Ssh connection chain to this server", (properties, args) -> this.serverContext.ssh(properties));
        this.add("responsibles", "server", Collections.emptyList(), Collections.emptyList(), "Show registered responsibles", (properties, args) -> this.serverContext.responsibles(properties));
        this.add("set-responsibles", "server", Arrays.asList("users"), Collections.emptyList(), "Assign responsibles of this device from registered", this.serverContext::setResponsibles);
        this.add("processes", "server", Collections.emptyList(), Collections.emptyList(), "State of processes related with this server", (properties, args) -> this.serverContext.processes(properties));
        this.add("remove-process", "server", Collections.singletonList("name"), Collections.emptyList(), "Removes process `process-name or index`. use extra parameter `force` to force remove", (properties, args) -> this.serverContext.removeProcess(properties, args.length > 0 ? args[0] : "", args.length > 1 ? args[1] : "none"));
        this.add("process", "server", Collections.singletonList("processId"), Arrays.asList("", "", "", "", "", "", "", "", "", "", "", "", "", "", ""), "Open a connection with a syste by either its `deviceId`, `name` or `position` to operate with it", (properties, args) -> this.serverContext.process(properties, args.length > 0 ? args[0] : ""));
        this.add("status", "server|process", Collections.emptyList(), Collections.emptyList(), "Status of the selected process", (properties, args) -> this.serverProcessContext.status(properties));
        this.add("log", "server|process", Collections.emptyList(), Collections.emptyList(), "Log of process", (properties, args) -> this.serverProcessContext.log(properties));
        this.add("history", "server|process", Collections.singletonList("metric"), Collections.emptyList(), "Show history of a metric of the process. It could be memory cpu or threads", (properties, args) -> this.serverProcessContext.history(properties, args.length > 0 ? args[0] : ""));
        this.add("tail", "server|process", Collections.singletonList("lines"), Collections.emptyList(), "Tail of Log of process", (properties, args) -> this.serverProcessContext.tail(properties, args.length > 0 ? args[0] : ""));
        this.add("parameter", "server|process", Arrays.asList("name", "value"), Collections.emptyList(), "Add or update value of a parameter", (properties, args) -> this.serverProcessContext.parameter(properties, args.length > 0 ? args[0] : "", args.length > 1 ? args[1] : ""));
        this.add("start", "server|process", Collections.emptyList(), Collections.emptyList(), "Start process", (properties, args) -> this.serverProcessContext.start(properties));
        this.add("debug", "server|process", Collections.emptyList(), Collections.emptyList(), "Start process with debug", (properties, args) -> this.serverProcessContext.debug(properties));
        this.add("stop", "server|process", Collections.emptyList(), Collections.emptyList(), "Stop process", (properties, args) -> this.serverProcessContext.stop(properties));
        this.add("restart", "server|process", Collections.emptyList(), Collections.emptyList(), "Restart process", (properties, args) -> this.serverProcessContext.restart(properties));
        this.add("parameters", "server|process", Collections.emptyList(), Collections.emptyList(), "Parameters of running process", (properties, args) -> this.serverProcessContext.parameters(properties));
        this.add("ssh", "server|process", Collections.emptyList(), Collections.emptyList(), "Ssh connection chain to the server its contained", (properties, args) -> this.serverProcessContext.ssh(properties));
        this.add("responsibles", "server|process", Collections.emptyList(), Collections.emptyList(), "Show registered responsibles", (properties, args) -> this.serverProcessContext.responsibles(properties));
        this.add("set-responsibles", "server|process", Arrays.asList("users"), Collections.emptyList(), "Assign responsibles to this process from registered", this.serverProcessContext::setResponsibles);
        this.add("invoke", "server|process", Arrays.asList("operation", "parameters"), Collections.emptyList(), "Invokes an available operation over this process", (properties, args) -> this.serverProcessContext.invoke(properties, args.length > 0 ? args[0] : "", args));
        this.add("operations", "server|process", Collections.emptyList(), Collections.emptyList(), "Shows available operations of this process", (properties, args) -> this.serverProcessContext.operations(properties));
        this.add("deployments", "server|process", Collections.emptyList(), Collections.emptyList(), "Shows the made deployments of this application.", (properties, args) -> this.serverProcessContext.deployments(properties));
        this.add("rollback", "server|process", Arrays.asList("deployment"), Collections.emptyList(), "Rollback an application to a deployment passing the index", (properties, args) -> this.serverProcessContext.rollback(properties, args.length > 0 ? args[0] : ""));
    }

    private static String formatCommand(String command, RestBot.CommandInfo info) {
        return "`" + command.substring(command.lastIndexOf("$") + 1) + CesarBot.helpParameters(info.parameters()) + "` " + info.description() + "\n";
    }

    private static String helpParameters(List<String> parameters) {
        return parameters.isEmpty() ? "" : " <" + String.join((CharSequence)"> <", parameters) + ">";
    }
}

