/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.actions;

import io.intino.alexandria.logger.Logger;
import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.bot.helpers.ImageHelper;
import io.intino.cesar.checkers.DeviceChecker;
import io.intino.cesar.checkers.ScreenDownloader;
import io.intino.cesar.checkers.ServerChecker;
import io.intino.cesar.graph.Device;
import io.intino.cesar.graph.Server;
import java.awt.image.BufferedImage;

public class ScheduleAssetCheckerAction {
    public CesarBox box;

    public void execute() {
        this.box.graph().assetList().forEach(unit -> {
            if (unit.core$().is(Device.class)) {
                Device device = unit.core$().as(Device.class);
                if (device.status() != null && device.isScreenOn()) {
                    this.downloadScreen(device);
                }
                this.checkDevice(device);
            } else {
                new ServerChecker(unit.core$().as(Server.class), this.box).check();
            }
        });
    }

    private void checkDevice(Device device) {
        try {
            new DeviceChecker(device, this.box).check();
        }
        catch (Throwable e) {
            Logger.error(e);
        }
    }

    private void downloadScreen(Device device) {
        byte[] image = new ScreenDownloader(this.box).screenOf(device);
        if (image != null && image.length != 0) {
            BufferedImage withTimeMark = ImageHelper.withTimeMark(device.screen(), image);
            if (withTimeMark == null) {
                Logger.error("image of " + device.label() + " is null");
                return;
            }
            device.screen().save(ImageHelper.decodeImage(withTimeMark));
        }
    }
}

