/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.actions;

import io.intino.alexandria.Base64;
import io.intino.alexandria.Context;
import io.intino.alexandria.exceptions.BadRequest;
import io.intino.alexandria.exceptions.Unauthorized;
import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.bot.RestBot;
import io.intino.cesar.box.schemas.BotResponse;
import io.intino.cesar.graph.User;
import java.io.IOException;
import java.time.Instant;
import java.util.TimeZone;

public class PostBotAction {
    public CesarBox box;
    public Context context = new Context();
    public String timeZone;
    public String query;

    public BotResponse execute() throws Unauthorized {
        User user = this.box.graph().userList().stream().filter(u -> u.token().equals(this.context.get("Authorization"))).findFirst().orElse(null);
        if (user == null) {
            throw new Unauthorized("Credential not found");
        }
        Object response = this.box.cesarBot().talk(user.name$(), this.query, this.properties(user));
        if (response instanceof String) {
            return new BotResponse().type(BotResponse.Type.text).raw(response.toString());
        }
        if (response instanceof RestBot.Attachment) {
            return new BotResponse().title(((RestBot.Attachment)response).getTitle()).fileName(((RestBot.Attachment)response).getFileName()).type(BotResponse.Type.valueOf(((RestBot.Attachment)response).getType().name().toLowerCase())).raw(this.encode((RestBot.Attachment)response));
        }
        return new BotResponse().type(BotResponse.Type.text).raw("Impossible to send file to this environment");
    }

    private String encode(RestBot.Attachment response) {
        try {
            return Base64.encode(response.getInputStream().readAllBytes());
        }
        catch (IOException e) {
            return "";
        }
    }

    private RestBot.MessageProperties properties(final User user) {
        return new RestBot.MessageProperties(){

            @Override
            public String channel() {
                return null;
            }

            @Override
            public String username() {
                return user.name$();
            }

            @Override
            public String ts() {
                return Instant.now().toString();
            }

            @Override
            public String timeZone() {
                return PostBotAction.this.timeZone == null ? TimeZone.getDefault().getID() : PostBotAction.this.timeZone;
            }

            @Override
            public RestBot.Context context() {
                return PostBotAction.this.box.cesarBot().contexts().get(user.name$());
            }

            @Override
            public RestBot.Attachment attachment() {
                return null;
            }
        };
    }

    public void onMalformedRequest(Throwable e) throws BadRequest {
        throw new BadRequest("Malformed request");
    }
}

