/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.http.AlexandriaSparkBuilder;
import io.intino.alexandria.logger.Formatter;
import io.intino.alexandria.scheduler.AlexandriaScheduler;
import io.intino.alexandria.terminal.Connector;
import io.intino.alexandria.terminal.JmsConnector;
import io.intino.cesar.box.ApiService;
import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.CesarConfiguration;
import io.intino.cesar.box.Sentinels;
import io.intino.cesar.box.subscribers.DeviceBootSubscriber;
import io.intino.cesar.box.subscribers.DeviceCrashSubscriber;
import io.intino.cesar.box.subscribers.DeviceUpgradeSubscriber;
import io.intino.cesar.box.subscribers.InfrastructureOperationSubscriber;
import io.intino.cesar.box.subscribers.ProcessLogSubscriber;
import io.intino.cesar.box.subscribers.ProcessStatusSubscriber;
import io.intino.cesar.box.subscribers.ServerBootSubscriber;
import io.intino.cesar.box.subscribers.ServerInfoSubscriber;
import io.intino.cesar.box.subscribers.ServerLogSubscriber;
import io.intino.cesar.box.subscribers.ServerStatusSubscriber;
import io.intino.cesar.datahub.CesarTerminal;
import io.intino.cesar.datahub.events.cesar.InfrastructureOperation;
import io.intino.cesar.datahub.events.consul.device.DeviceBoot;
import io.intino.cesar.datahub.events.consul.device.DeviceCrash;
import io.intino.cesar.datahub.events.consul.device.DeviceUpgrade;
import io.intino.cesar.datahub.events.consul.process.ProcessLog;
import io.intino.cesar.datahub.events.consul.process.ProcessStatus;
import io.intino.cesar.datahub.events.consul.server.ServerBoot;
import io.intino.cesar.datahub.events.consul.server.ServerInfo;
import io.intino.cesar.datahub.events.consul.server.ServerLog;
import io.intino.cesar.datahub.events.consul.server.ServerStatus;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Instant;
import java.util.function.Predicate;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractBox
extends Box {
    protected CesarConfiguration configuration;
    protected Connector connector;
    protected CesarTerminal terminal;
    private AlexandriaScheduler scheduler = new AlexandriaScheduler();

    public AbstractBox(String[] args) {
        this(new CesarConfiguration(args));
    }

    public AbstractBox(CesarConfiguration configuration) {
        this.configuration = configuration;
        this.initJavaLogger();
        this.connector = new JmsConnector(this.configuration().get("datahub_url"), this.configuration().get("datahub_user"), this.configuration().get("datahub_password"), this.configuration().get("datahub_clientId"), this.configuration().get("datahub_outbox_directory") == null ? null : new File(this.configuration().get("datahub_outbox_directory")));
        this.terminal = new CesarTerminal(this.connector);
    }

    @Override
    public CesarConfiguration configuration() {
        return this.configuration;
    }

    @Override
    public Box put(Object o) {
        return this;
    }

    @Override
    public abstract void beforeStart();

    @Override
    public Box start() {
        if (this.owner != null) {
            this.owner.beforeStart();
        }
        this.beforeStart();
        if (this.owner != null) {
            this.owner.startServices();
        }
        this.startServices();
        if (this.owner != null) {
            this.owner.afterStart();
        }
        this.afterStart();
        return this;
    }

    @Override
    public abstract void afterStart();

    @Override
    public abstract void beforeStop();

    @Override
    public void stop() {
        if (this.owner != null) {
            this.owner.beforeStop();
        }
        this.beforeStop();
        if (this.owner != null) {
            this.owner.stopServices();
        }
        this.stopServices();
        if (this.owner != null) {
            this.owner.afterStop();
        }
        this.afterStop();
    }

    @Override
    public void stopServices() {
        AlexandriaSparkBuilder.instance().stop();
        if (this.connector instanceof JmsConnector) {
            ((JmsConnector)this.connector).stop();
        }
    }

    @Override
    public abstract void afterStop();

    @Override
    public void startServices() {
        this.initUI();
        this.initConnector();
        this.initRestServices();
        this.initSoapServices();
        this.initJmxServices();
        this.initDatalake();
        this.initTerminal();
        this.initMessagingServices();
        this.initSentinels();
        this.initSlackBots();
        this.initWorkflow();
        this.initAgenda();
    }

    public CesarTerminal terminal() {
        return this.terminal;
    }

    protected Connector datahubConnector() {
        return this.connector;
    }

    public AlexandriaScheduler scheduler() {
        return this.scheduler;
    }

    private void initRestServices() {
        if ("9000".isEmpty()) {
            return;
        }
        AlexandriaSparkBuilder.setup(Integer.parseInt("9000"), "www/");
        ApiService.setup(AlexandriaSparkBuilder.instance(), (CesarBox)this);
        AlexandriaSparkBuilder.instance().start();
        io.intino.alexandria.logger.Logger.info("Rest service api: started at port 9000!");
    }

    private void initSoapServices() {
    }

    private void initMessagingServices() {
    }

    private void initJmxServices() {
    }

    private void initSlackBots() {
    }

    private void initUI() {
    }

    private void initDatalake() {
    }

    private void initConnector() {
        if (this.connector instanceof JmsConnector && ((JmsConnector)this.connector).connection() != null) {
            return;
        }
        JmsConnector connector = (JmsConnector)this.connector;
        if (connector.connection() == null) {
            connector.start();
        }
        if (this.configuration().get("datahub_url").contains("waitUntilConnect=true")) {
            while (connector.connection() == null) {
                try {
                    Thread.sleep(30000L);
                    connector.start();
                }
                catch (InterruptedException e) {
                    io.intino.alexandria.logger.Logger.error(e);
                }
            }
        }
    }

    private void initTerminal() {
        if (this.terminal != null) {
            Instant sealStamp = this.terminal.requestLastSeal();
            io.intino.alexandria.logger.Logger.info("Last seal on " + sealStamp.toString());
            Predicate<Instant> filter = i -> !i.isBefore(sealStamp);
            this.terminal.subscribe((e, t) -> new ServerBootSubscriber((CesarBox)this).accept((ServerBoot)e, (String)t), "cesar-server-boot", filter);
            this.terminal.subscribe((e, t) -> new ServerInfoSubscriber((CesarBox)this).accept((ServerInfo)e, (String)t), "cesar-server-info", filter);
            this.terminal.subscribe((e, t) -> new ServerLogSubscriber((CesarBox)this).accept((ServerLog)e, (String)t), "cesar-server-log", filter);
            this.terminal.subscribe((e, t) -> new ServerStatusSubscriber((CesarBox)this).accept((ServerStatus)e, (String)t), "cesar-server-status", filter);
            this.terminal.subscribe((e, t) -> new DeviceBootSubscriber((CesarBox)this).accept((DeviceBoot)e, (String)t), "cesar-device-boot", filter);
            this.terminal.subscribe((e, t) -> new DeviceUpgradeSubscriber((CesarBox)this).accept((DeviceUpgrade)e, (String)t), "cesar-device-upgrade", filter);
            this.terminal.subscribe((e, t) -> new DeviceCrashSubscriber((CesarBox)this).accept((DeviceCrash)e, (String)t), "cesar-device-crash", filter);
            this.terminal.subscribe((e, t) -> new ProcessLogSubscriber((CesarBox)this).accept((ProcessLog)e, (String)t), "cesar-process-log", filter);
            this.terminal.subscribe((e, t) -> new ProcessStatusSubscriber((CesarBox)this).accept((ProcessStatus)e, (String)t), "cesar-process-status", filter);
            this.terminal.subscribe((e, t) -> new InfrastructureOperationSubscriber((CesarBox)this).accept((InfrastructureOperation)e, (String)t));
        }
    }

    private void initSentinels() {
        Sentinels.init(this.scheduler, this.configuration.home(), (CesarBox)this);
    }

    private void initWorkflow() {
    }

    private void initAgenda() {
    }

    private void initJavaLogger() {
        Logger Logger2 = Logger.getGlobal();
        ConsoleHandler handler = new ConsoleHandler();
        handler.setLevel(Level.INFO);
        handler.setFormatter(new Formatter());
        Logger2.setUseParentHandlers(false);
        Logger2.addHandler(handler);
        io.intino.alexandria.logger4j.Logger.init();
    }

    protected URL url(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }
}

