/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.terminal;

import io.intino.alexandria.Scale;
import io.intino.alexandria.Timetag;
import io.intino.alexandria.event.Event;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.message.MessageReader;
import io.intino.alexandria.terminal.OutBox;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.UUID;

class EventOutBox
extends OutBox {
    private static final String INL = ".inl";

    EventOutBox(File directory) {
        super(directory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Map.Entry<String, Event>> get() {
        ArrayList<Map.Entry<String, Event>> events = new ArrayList<Map.Entry<String, Event>>();
        List list = this.files;
        synchronized (list) {
            this.files.sort(Comparator.comparingLong(File::lastModified));
            if (this.files.isEmpty()) {
                return Collections.emptyList();
            }
            for (File file : this.files) {
                try {
                    if (!file.exists()) {
                        this.files.remove(file);
                        continue;
                    }
                    String content = Files.readString(file.toPath());
                    if (content.isEmpty() || content.isBlank()) {
                        file.delete();
                        this.files.remove(file);
                        continue;
                    }
                    events.add(new AbstractMap.SimpleEntry<String, Event>(this.destination(file), new Event(new MessageReader(content).next())));
                }
                catch (IOException e) {
                    Logger.error(e);
                }
            }
        }
        return events;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void push(String channel, Event event) {
        File file = new File(this.directory, channel + "#" + this.timetag(event) + "#" + UUID.randomUUID() + INL);
        try {
            Files.write(file.toPath(), event.toString().getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            Logger.error(e);
        }
        List list = this.files;
        synchronized (list) {
            this.files.add(file);
        }
    }

    private String timetag(Event event) {
        return new Timetag(LocalDateTime.ofInstant(event.ts(), ZoneOffset.UTC), Scale.Minute).toString();
    }

    @Override
    protected String destination(File file) {
        return file.getName().substring(0, file.getName().indexOf("#"));
    }

    @Override
    protected String extension() {
        return INL;
    }
}

