/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria;

import io.intino.alexandria.Scale;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Iterator;
import java.util.List;

public class Timetag {
    private static final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
    private static final DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyyMMdd000000");
    private final String tag;

    public Timetag(LocalDateTime dateTime, Scale scale) {
        this(dateTimeFormatter.format(dateTime).substring(0, Timetag.sizeOf(scale)));
    }

    public Timetag(Instant instant, Scale scale) {
        this(Timetag.toString(instant).substring(0, Timetag.sizeOf(scale)));
    }

    public Timetag(LocalDate date, Scale scale) {
        this(dateFormatter.format(date).substring(0, Timetag.sizeOf(scale)));
    }

    public Timetag(String tag) {
        this.tag = tag;
    }

    public static Timetag of(String tag) {
        return new Timetag(tag);
    }

    public static Timetag of(LocalDateTime datetime, Scale scale) {
        return new Timetag(datetime, scale);
    }

    public static Timetag of(LocalDate date, Scale scale) {
        return new Timetag(date, scale);
    }

    public static Timetag of(Instant instant, Scale scale) {
        return new Timetag(instant, scale);
    }

    public int year() {
        return Integer.parseInt(this.tag.substring(0, 4));
    }

    public int month() {
        return this.hasMonth() ? Integer.parseInt(this.tag.substring(4, 6)) : 1;
    }

    public int day() {
        return this.hasDay() ? Integer.parseInt(this.tag.substring(6, 8)) : 1;
    }

    public int hour() {
        return this.hasHour() ? Integer.parseInt(this.tag.substring(8, 10)) : 0;
    }

    public int minute() {
        return this.hasMinute() ? Integer.parseInt(this.tag.substring(10, 12)) : 0;
    }

    public boolean hasMonth() {
        return this.precision() > 0;
    }

    public boolean hasDay() {
        return this.precision() > 1;
    }

    public boolean hasHour() {
        return this.precision() > 2;
    }

    public boolean hasMinute() {
        return this.precision() > 3;
    }

    public LocalDateTime datetime() {
        return LocalDateTime.of(this.year(), this.month(), this.day(), this.hour(), this.minute());
    }

    public Scale scale() {
        return Scale.values()[this.precision()];
    }

    private int precision() {
        return (this.tag.length() - 4) / 2;
    }

    public String value() {
        return this.tag;
    }

    public String label() {
        Object result = this.tag;
        for (int i = ((String)result).length(); i > 4; i -= 2) {
            result = ((String)result).substring(0, i - 2) + "-" + ((String)result).substring(i - 2);
        }
        return result;
    }

    public Timetag next() {
        return this.next(1);
    }

    public Timetag next(int count) {
        return new Timetag(this.calculate(count), this.scale());
    }

    public Timetag previous() {
        return this.previous(1);
    }

    public Timetag previous(int count) {
        return new Timetag(this.calculate(-count), this.scale());
    }

    public Iterable<Timetag> iterateTo(final Timetag to) {
        return () -> new Iterator<Timetag>(){
            Timetag current;
            {
                this.current = Timetag.this;
            }

            @Override
            public boolean hasNext() {
                return !this.current.isAfter(to);
            }

            @Override
            public Timetag next() {
                Timetag result = this.current;
                this.current = this.current.next();
                return result;
            }
        };
    }

    public boolean isAfter(Timetag timetag) {
        return this.datetime().isAfter(timetag.datetime());
    }

    public boolean isBefore(Timetag timetag) {
        return this.datetime().isBefore(timetag.datetime());
    }

    public int compare(Timetag timetag) {
        return this.datetime().compareTo(timetag.datetime());
    }

    private LocalDateTime calculate(int amount) {
        return this.scale().temporalUnit().addTo(this.datetime(), amount);
    }

    private static int sizeOf(Scale scale) {
        return scale.ordinal() * 2 + 4;
    }

    private static String toString(Instant instant) {
        return instant.toString().replaceAll("[-TZ\\.:]", "");
    }

    public boolean equals(Object o) {
        if (o instanceof String) {
            return this.tag.equals(o);
        }
        if (o instanceof Timetag) {
            return this.tag.equals(((Timetag)o).tag);
        }
        if (o instanceof Instant) {
            return this.tag.equals(new Timetag((Instant)((Instant)o), (Scale)this.scale()).tag);
        }
        return false;
    }

    public boolean isIn(List<Timetag> timetags) {
        return timetags.stream().anyMatch(t -> t.equals(this));
    }

    public int hashCode() {
        return this.tag.hashCode();
    }

    public String toString() {
        return this.tag;
    }
}

