/*
 * Decompiled with CFR 0.152.
 */
package eu.medsea.mimeutil;

import eu.medsea.mimeutil.MimeDetectorRegistry;
import eu.medsea.mimeutil.MimeException;
import eu.medsea.mimeutil.MimeType;
import eu.medsea.mimeutil.MimeTypeHashSet;
import eu.medsea.mimeutil.TextMimeType;
import eu.medsea.mimeutil.detector.MimeDetector;
import eu.medsea.util.StringUtil;
import eu.medsea.util.ZipJarUtil;
import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.zip.ZipException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MimeUtil2 {
    private static Logger log;
    public static final MimeType DIRECTORY_MIME_TYPE;
    public static final MimeType UNKNOWN_MIME_TYPE;
    private static final Pattern mimeSplitter;
    private static Map mimeTypes;
    private static ByteOrder nativeByteOrder;
    private MimeDetectorRegistry mimeDetectorRegistry = new MimeDetectorRegistry();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("eu.medsea.mimeutil.MimeUtil2");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LoggerFactory.getLogger(clazz);
        DIRECTORY_MIME_TYPE = new MimeType("application/directory");
        UNKNOWN_MIME_TYPE = new MimeType("application/octet-stream");
        mimeSplitter = Pattern.compile("[/;]++");
        mimeTypes = Collections.synchronizedMap(new HashMap());
        nativeByteOrder = ByteOrder.nativeOrder();
    }

    public static void addKnownMimeType(MimeType mimeType) {
        MimeUtil2.addKnownMimeType(mimeType.toString());
    }

    public static void addKnownMimeType(String mimeType) {
        try {
            String key = MimeUtil2.getMediaType(mimeType);
            TreeSet<String> s = (TreeSet<String>)mimeTypes.get(key);
            if (s == null) {
                s = new TreeSet<String>();
            }
            s.add(MimeUtil2.getSubType(mimeType));
            mimeTypes.put(key, s);
        }
        catch (MimeException mimeException) {
            // empty catch block
        }
    }

    public MimeDetector registerMimeDetector(String mimeDetector) {
        return this.mimeDetectorRegistry.registerMimeDetector(mimeDetector);
    }

    public static String getExtension(File file) {
        return MimeUtil2.getExtension(file.getName());
    }

    public static String getExtension(String fileName) {
        if (fileName == null || fileName.length() == 0) {
            return "";
        }
        int index = fileName.indexOf(".");
        return index < 0 ? "" : fileName.substring(index + 1);
    }

    public static MimeType getFirstMimeType(String mimeTypes) {
        if (mimeTypes != null && mimeTypes.trim().length() != 0) {
            return new MimeType(mimeTypes.split(",")[0].trim());
        }
        return null;
    }

    public static String getMediaType(String mimeType) throws MimeException {
        return new MimeType(mimeType).getMediaType();
    }

    public static double getMimeQuality(String mimeType) throws MimeException {
        if (mimeType == null) {
            throw new MimeException("Invalid MimeType [" + mimeType + "].");
        }
        String[] parts = mimeSplitter.split(mimeType);
        if (parts.length < 2) {
            throw new MimeException("Invalid MimeType [" + mimeType + "].");
        }
        if (parts.length > 2) {
            int i = 2;
            while (i < parts.length) {
                if (parts[i].trim().startsWith("q=")) {
                    try {
                        double d = Double.parseDouble(parts[i].split("=")[1].trim());
                        return d > 1.0 ? 1.0 : d;
                    }
                    catch (NumberFormatException e) {
                        throw new MimeException("Invalid MIME quality indicator [" + parts[i].trim() + "]. Must be a valid double between 0 and 1");
                    }
                    catch (Exception e) {
                        throw new MimeException("Error parsing MIME quality indicator.", e);
                    }
                }
                ++i;
            }
        }
        if (StringUtil.contains(parts[0], "*")) {
            return 0.01;
        }
        if (StringUtil.contains(parts[1], "*")) {
            return 0.02;
        }
        return 1.0;
    }

    public MimeDetector getMimeDetector(String name) {
        return this.mimeDetectorRegistry.getMimeDetector(name);
    }

    public final Collection getMimeTypes(byte[] data) throws MimeException {
        return this.getMimeTypes(data, UNKNOWN_MIME_TYPE);
    }

    public final Collection getMimeTypes(byte[] data, MimeType unknownMimeType) throws MimeException {
        MimeTypeHashSet mimeTypes = new MimeTypeHashSet();
        if (data == null) {
            log.error("byte array cannot be null.");
        } else {
            if (log.isDebugEnabled()) {
                try {
                    log.debug("Getting MIME types for byte array [" + StringUtil.getHexString(data) + "].");
                }
                catch (UnsupportedEncodingException e) {
                    throw new MimeException(e);
                }
            }
            mimeTypes.addAll(this.mimeDetectorRegistry.getMimeTypes(data));
            mimeTypes.remove(unknownMimeType);
        }
        if (mimeTypes.isEmpty()) {
            mimeTypes.add(unknownMimeType);
        }
        if (log.isDebugEnabled()) {
            log.debug("Retrieved MIME types [" + ((Object)mimeTypes).toString() + "]");
        }
        return mimeTypes;
    }

    public final Collection getMimeTypes(File file) throws MimeException {
        return this.getMimeTypes(file, UNKNOWN_MIME_TYPE);
    }

    public final Collection getMimeTypes(File file, MimeType unknownMimeType) throws MimeException {
        MimeTypeHashSet mimeTypes = new MimeTypeHashSet();
        if (file == null) {
            log.error("File reference cannot be null.");
        } else {
            if (log.isDebugEnabled()) {
                log.debug("Getting MIME types for file [" + file.getAbsolutePath() + "].");
            }
            if (file.isDirectory()) {
                mimeTypes.add(DIRECTORY_MIME_TYPE);
                return mimeTypes;
            }
            mimeTypes.addAll(this.mimeDetectorRegistry.getMimeTypes(file));
            mimeTypes.remove(unknownMimeType);
        }
        if (mimeTypes.isEmpty()) {
            mimeTypes.add(unknownMimeType);
        }
        if (log.isDebugEnabled()) {
            log.debug("Retrieved MIME types [" + ((Object)mimeTypes).toString() + "]");
        }
        return mimeTypes;
    }

    public final Collection getMimeTypes(InputStream in) throws MimeException {
        return this.getMimeTypes(in, UNKNOWN_MIME_TYPE);
    }

    public final Collection getMimeTypes(InputStream in, MimeType unknownMimeType) throws MimeException {
        MimeTypeHashSet mimeTypes = new MimeTypeHashSet();
        if (in == null) {
            log.error("InputStream reference cannot be null.");
        } else {
            if (!in.markSupported()) {
                throw new MimeException("InputStream must support the mark() and reset() methods.");
            }
            if (log.isDebugEnabled()) {
                log.debug("Getting MIME types for InputSteam [" + in + "].");
            }
            mimeTypes.addAll(this.mimeDetectorRegistry.getMimeTypes(in));
            mimeTypes.remove(unknownMimeType);
        }
        if (mimeTypes.isEmpty()) {
            mimeTypes.add(unknownMimeType);
        }
        if (log.isDebugEnabled()) {
            log.debug("Retrieved MIME types [" + ((Object)mimeTypes).toString() + "]");
        }
        return mimeTypes;
    }

    public final Collection getMimeTypes(String fileName) throws MimeException {
        return this.getMimeTypes(fileName, UNKNOWN_MIME_TYPE);
    }

    public final Collection getMimeTypes(String fileName, MimeType unknownMimeType) throws MimeException {
        MimeTypeHashSet mimeTypes = new MimeTypeHashSet();
        if (fileName == null) {
            log.error("fileName cannot be null.");
        } else {
            File file;
            if (log.isDebugEnabled()) {
                log.debug("Getting MIME types for file name [" + fileName + "].");
            }
            if ((file = new File(fileName)).isDirectory()) {
                mimeTypes.add(DIRECTORY_MIME_TYPE);
                return mimeTypes;
            }
            mimeTypes.addAll(this.mimeDetectorRegistry.getMimeTypes(fileName));
            mimeTypes.remove(unknownMimeType);
        }
        if (mimeTypes.isEmpty()) {
            mimeTypes.add(unknownMimeType);
        }
        if (log.isDebugEnabled()) {
            log.debug("Retrieved MIME types [" + ((Object)mimeTypes).toString() + "]");
        }
        return mimeTypes;
    }

    public final Collection getMimeTypes(URL url) throws MimeException {
        return this.getMimeTypes(url, UNKNOWN_MIME_TYPE);
    }

    public final Collection getMimeTypes(URL url, MimeType unknownMimeType) throws MimeException {
        MimeTypeHashSet mimeTypes = new MimeTypeHashSet();
        if (url == null) {
            log.error("URL reference cannot be null.");
        } else {
            File file;
            if (log.isDebugEnabled()) {
                log.debug("Getting MIME types for URL [" + url + "].");
            }
            if ((file = new File(url.getPath())).isDirectory()) {
                mimeTypes.add(DIRECTORY_MIME_TYPE);
                return mimeTypes;
            }
            mimeTypes.addAll(this.mimeDetectorRegistry.getMimeTypes(url));
            mimeTypes.remove(unknownMimeType);
        }
        if (mimeTypes.isEmpty()) {
            mimeTypes.add(unknownMimeType);
        }
        if (log.isDebugEnabled()) {
            log.debug("Retrieved MIME types [" + ((Object)mimeTypes).toString() + "]");
        }
        return mimeTypes;
    }

    public static ByteOrder getNativeOrder() {
        return nativeByteOrder;
    }

    public static MimeType getPreferedMimeType(String accept, String canProvide) {
        if (canProvide == null || canProvide.trim().length() == 0) {
            throw new MimeException("Must specify at least one MIME type that can be provided.");
        }
        if (accept == null || accept.trim().length() == 0) {
            accept = "*/*";
        }
        if (accept.indexOf(":") > 0) {
            accept = accept.substring(accept.indexOf(":") + 1);
        }
        accept = accept.replaceAll(" ", "");
        return MimeUtil2.getBestMatch(accept, MimeUtil2.getList(canProvide));
    }

    public static MimeType getMostSpecificMimeType(Collection mimeTypes) {
        MimeType mimeType = null;
        int specificity = 0;
        Iterator it = mimeTypes.iterator();
        while (it.hasNext()) {
            MimeType mt = (MimeType)it.next();
            if (mt.getSpecificity() <= specificity) continue;
            mimeType = mt;
        }
        return mimeType;
    }

    public static String getSubType(String mimeType) throws MimeException {
        return new MimeType(mimeType).getSubType();
    }

    public static boolean isMimeTypeKnown(MimeType mimeType) {
        Set s;
        block3: {
            try {
                s = (Set)mimeTypes.get(mimeType.getMediaType());
                if (s != null) break block3;
                return false;
            }
            catch (MimeException e) {
                return false;
            }
        }
        return s.contains(mimeType.getSubType());
    }

    public static boolean isMimeTypeKnown(String mimeType) {
        return MimeUtil2.isMimeTypeKnown(new MimeType(mimeType));
    }

    public static boolean isTextMimeType(MimeType mimeType) {
        return mimeType instanceof TextMimeType;
    }

    public MimeDetector unregisterMimeDetector(MimeDetector mimeDetector) {
        return this.mimeDetectorRegistry.unregisterMimeDetector(mimeDetector);
    }

    public MimeDetector unregisterMimeDetector(String mimeDetector) {
        return this.mimeDetectorRegistry.unregisterMimeDetector(mimeDetector);
    }

    public static double getQuality(String mimeType) throws MimeException {
        return MimeUtil2.getMimeQuality(mimeType);
    }

    private static MimeType getBestMatch(String accept, List canProvideList) {
        if (canProvideList.size() == 1) {
            return new MimeType((String)canProvideList.get(0));
        }
        Map wantedMap = MimeUtil2.normaliseWantedMap(accept, canProvideList);
        MimeType bestMatch = null;
        double qos = 0.0;
        Iterator it = wantedMap.keySet().iterator();
        while (it.hasNext()) {
            List wantedList = (List)wantedMap.get(it.next());
            Iterator it2 = wantedList.iterator();
            while (it2.hasNext()) {
                String mimeType = (String)it2.next();
                double q = MimeUtil2.getMimeQuality(mimeType);
                String majorComponent = MimeUtil2.getMediaType(mimeType);
                String minorComponent = MimeUtil2.getSubType(mimeType);
                if (!(q > qos)) continue;
                qos = q;
                bestMatch = new MimeType(String.valueOf(majorComponent) + "/" + minorComponent);
            }
        }
        return bestMatch;
    }

    private static List getList(String options) {
        ArrayList<String> list = new ArrayList<String>();
        String[] array = options.split(",");
        int i = 0;
        while (i < array.length) {
            list.add(array[i].trim());
            ++i;
        }
        return list;
    }

    private static Map normaliseWantedMap(String accept, List canProvide) {
        LinkedHashMap map = new LinkedHashMap();
        String[] array = accept.split(",");
        int i = 0;
        while (i < array.length) {
            List<String> list;
            String mt;
            Iterator it;
            String mimeType = array[i].trim();
            String major = MimeUtil2.getMediaType(mimeType);
            String minor = MimeUtil2.getSubType(mimeType);
            double qos = MimeUtil2.getMimeQuality(mimeType);
            if (StringUtil.contains(major, "*")) {
                it = canProvide.iterator();
                while (it.hasNext()) {
                    mt = (String)it.next();
                    list = (ArrayList<String>)map.get(MimeUtil2.getMediaType(mt));
                    if (list == null) {
                        list = new ArrayList<String>();
                    }
                    list.add(String.valueOf(mt) + ";q=" + qos);
                    map.put(MimeUtil2.getMediaType(mt), list);
                }
            } else if (StringUtil.contains(minor, "*")) {
                it = canProvide.iterator();
                while (it.hasNext()) {
                    mt = (String)it.next();
                    if (!MimeUtil2.getMediaType(mt).equals(major)) continue;
                    list = (List)map.get(major);
                    if (list == null) {
                        list = new ArrayList();
                    }
                    list.add(String.valueOf(major) + "/" + MimeUtil2.getSubType(mt) + ";q=" + qos);
                    map.put(major, list);
                }
            } else if (canProvide.contains(String.valueOf(major) + "/" + minor)) {
                ArrayList<String> list2 = (ArrayList<String>)map.get(major);
                if (list2 == null) {
                    list2 = new ArrayList<String>();
                }
                list2.add(String.valueOf(major) + "/" + minor + ";q=" + qos);
                map.put(major, list2);
            }
            ++i;
        }
        return map;
    }

    public static InputStream getInputStreamForURL(URL url) throws Exception {
        try {
            return url.openStream();
        }
        catch (ZipException e) {
            return ZipJarUtil.getInputStreamForURL(url);
        }
    }
}

