/*
 * Decompiled with CFR 0.152.
 */
package com.github.baloise.rocketchatrestclient;

import com.github.baloise.rocketchatrestclient.RocketChatClientCallBuilder;
import com.github.baloise.rocketchatrestclient.RocketChatClientResponse;
import com.github.baloise.rocketchatrestclient.RocketChatQueryParams;
import com.github.baloise.rocketchatrestclient.RocketChatRestApiV1;
import com.github.baloise.rocketchatrestclient.model.Channel;
import com.github.baloise.rocketchatrestclient.model.Integration;
import com.github.baloise.rocketchatrestclient.model.User;
import com.github.baloise.rocketchatrestclient.requests.ChannelHistoryRequest;
import com.github.baloise.rocketchatrestclient.requests.RoomAndUserRequest;
import java.io.IOException;
import java.util.Date;

public class RocketChatRestApiV1Channels {
    private static final String ROOM_ID_PARAM_KEY = "roomId";
    private RocketChatClientCallBuilder callBuilder;

    protected RocketChatRestApiV1Channels(RocketChatClientCallBuilder callBuilder) {
        this.callBuilder = callBuilder;
    }

    public Channel addAllUsers(Channel channel) throws IOException {
        RocketChatClientResponse res = this.callBuilder.buildCall(RocketChatRestApiV1.ChannelsAddAll, null, channel);
        if (!res.isSuccessful()) {
            throw new IOException("The call to add all users to a channel was unsuccessful: \"" + res.getError() + "\"");
        }
        if (!res.hasChannel()) {
            throw new IOException("The response does not contain any channel information.");
        }
        return res.getChannel();
    }

    public void addModerator(Channel channel, User user) throws IOException {
        RocketChatClientResponse res = this.callBuilder.buildCall(RocketChatRestApiV1.ChannelsAddModerator, null, new RoomAndUserRequest(channel.getId(), user.getId()));
        if (!res.isSuccessful()) {
            throw new IOException("The call to add a moderator was unsuccessful: \"" + res.getError() + "\"");
        }
    }

    public void addOwner(Channel channel, User user) throws IOException {
        RocketChatClientResponse res = this.callBuilder.buildCall(RocketChatRestApiV1.ChannelsAddOwner, null, new RoomAndUserRequest(channel.getId(), user.getId()));
        if (!res.isSuccessful()) {
            throw new IOException("The call tomessageReturn.channel add an owner was unsuccessful: \"" + res.getError() + "\"");
        }
    }

    public void archive(Channel channel) throws IOException {
        RocketChatClientResponse res = this.callBuilder.buildCall(RocketChatRestApiV1.ChannelsArchive, null, channel);
        if (!res.isSuccessful()) {
            throw new IOException("The call to archive the Channel was unsuccessful: \"" + res.getError() + "\"");
        }
    }

    public void cleanHistory(Channel channel, Date latest, Date oldest, boolean inclusive) throws IOException {
        ChannelHistoryRequest request = new ChannelHistoryRequest(channel.getId());
        if (latest == null || oldest == null) {
            throw new IOException("latest and oldest must not be null");
        }
        request.setLatest(latest);
        request.setOldest(oldest);
        request.setInclusive(inclusive);
        this.cleanHistory(request);
    }

    public void cleanHistory(ChannelHistoryRequest historyParams) throws IOException {
        RocketChatClientResponse res = this.callBuilder.buildCall(RocketChatRestApiV1.ChannelsCleanHistory, null, historyParams);
        if (!res.isSuccessful()) {
            throw new IOException("The call to clean the Channel was unsuccessful: \"" + res.getError() + "\"");
        }
    }

    public void close(Channel channel) throws IOException {
        RocketChatClientResponse res = this.callBuilder.buildCall(RocketChatRestApiV1.ChannelsClose, null, channel);
        if (!res.isSuccessful()) {
            throw new IOException("The call to close the Channel was unsuccessful: \"" + res.getError() + "\"");
        }
    }

    public Channel create(Channel channel) throws IOException {
        RocketChatClientResponse res = this.callBuilder.buildCall(RocketChatRestApiV1.ChannelsCreate, null, channel);
        if (!res.isSuccessful()) {
            throw new IOException("The call to create a Channel was unsuccessful: \"" + res.getError() + "\"");
        }
        if (!res.hasChannel()) {
            throw new IOException("The response does not contain any channel information.");
        }
        return res.getChannel();
    }

    public Channel delete(Channel channel) throws IOException {
        RocketChatClientResponse res = this.callBuilder.buildCall(RocketChatRestApiV1.ChannelsDelete, null, channel);
        if (!res.isSuccessful()) {
            throw new IOException("The call to delete a Channel was unsuccessful: \"" + res.getError() + "\"");
        }
        if (!res.hasChannel()) {
            throw new IOException("The response does not contain any channel information.");
        }
        return res.getChannel();
    }

    public Integration[] getIntegrations(Channel channel) throws IOException {
        RocketChatClientResponse res = this.callBuilder.buildCall(RocketChatRestApiV1.ChannelsGetIntegrations, new RocketChatQueryParams(ROOM_ID_PARAM_KEY, channel.getId()));
        if (!res.isSuccessful()) {
            throw new IOException("The call to get the Channel's Integrations was unsuccessful: \"" + res.getError() + "\"");
        }
        if (!res.hasIntegrations()) {
            throw new IOException("The respone does no contain any integrations information.");
        }
        return res.getIntegrations();
    }

    public Channel info(String channelId) throws IOException {
        return this.info(new Channel(channelId, ""));
    }

    public Channel info(Channel channel) throws IOException {
        RocketChatClientResponse res = this.callBuilder.buildCall(RocketChatRestApiV1.ChannelsInfo, new RocketChatQueryParams(ROOM_ID_PARAM_KEY, channel.getId()));
        if (!res.isSuccessful()) {
            throw new IOException("The call to get the Channel's information was unsuccessful: \"" + res.getError() + "\"");
        }
        if (!res.hasChannel()) {
            throw new IOException("The call to get the Channel's information was unsuccessful, failed to return channel data.");
        }
        return res.getChannel();
    }

    public Channel invite(Channel channel, User user) throws IOException {
        RocketChatClientResponse res = this.callBuilder.buildCall(RocketChatRestApiV1.ChannelsInvite, null, new RoomAndUserRequest(channel.getId(), user.getId()));
        if (!res.isSuccessful()) {
            throw new IOException("The call to invite a User to a Channel was unsuccessful: \"" + res.getError() + "\"");
        }
        if (!res.hasChannel()) {
            throw new IOException("The call to invite a User to a Channel failed to return the channel data.");
        }
        return res.getChannel();
    }

    public Channel join(Channel channel) throws IOException {
        throw new IOException("Not implemented.");
    }

    public Channel kick(Channel channel, User user) throws IOException {
        RocketChatClientResponse res = this.callBuilder.buildCall(RocketChatRestApiV1.ChannelsKick, null, new RoomAndUserRequest(channel.getId(), user.getId()));
        if (!res.isSuccessful()) {
            throw new IOException("The call to remove a User from a Channel was unsuccessful: \"" + res.getError() + "\"");
        }
        if (!res.hasChannel()) {
            throw new IOException("The call to kick a User from a Channel failed to return the channel data.");
        }
        return res.getChannel();
    }

    public Channel leave(Channel channel) throws IOException {
        RocketChatClientResponse res = this.callBuilder.buildCall(RocketChatRestApiV1.ChannelsLeave, null, channel);
        if (!res.isSuccessful()) {
            throw new IOException("The call to leave a Channel was unsuccessful: \"" + res.getError() + "\"");
        }
        if (!res.hasChannel()) {
            throw new IOException("The call to leave a Channel failed to return the channel data.");
        }
        return res.getChannel();
    }

    public Channel findByName(String channelName) throws IOException {
        if (channelName != null) {
            RocketChatQueryParams queryParam = new RocketChatQueryParams("query", "{ \"name\": \"" + channelName + "\" }");
            Channel[] list = this.list(queryParam);
            if (list.length > 1) {
                throw new IOException("Multiple channels with channelName " + channelName + " found.");
            }
            if (list.length == 1) {
                return list[0];
            }
        }
        return null;
    }

    public Channel[] list() throws IOException {
        return this.list(new RocketChatQueryParams());
    }

    public Channel[] list(RocketChatQueryParams params) throws IOException {
        RocketChatClientResponse res = this.callBuilder.buildCall(RocketChatRestApiV1.ChannelsList, params);
        if (!res.isSuccessful()) {
            throw new IOException("The call to get the Public Channels was unsuccessful: \"" + res.getError() + "\"");
        }
        if (!res.hasChannels()) {
            throw new IOException("Get Channels failed to retrieve the channels.");
        }
        return res.getChannels();
    }

    public Channel[] listJoined(RocketChatQueryParams params) throws IOException {
        throw new IOException("list.joined not implemented yet.");
    }

    public void open(Channel channel) throws IOException {
        RocketChatClientResponse res = this.callBuilder.buildCall(RocketChatRestApiV1.ChannelsOpen, null, channel);
        if (!res.isSuccessful()) {
            throw new IOException("The call to open the Channel was unsuccessful: \"" + res.getError() + "\"");
        }
    }

    public void removeModerator(Channel channel, User user) throws IOException {
        throw new IOException("Not Implemented.");
    }

    public void removeOwner(Channel channel, User user) throws IOException {
        throw new IOException("Not Implemented.");
    }

    public Channel rename(Channel channel) throws IOException {
        RocketChatClientResponse res = this.callBuilder.buildCall(RocketChatRestApiV1.ChannelsRename, null, channel);
        if (!res.isSuccessful()) {
            throw new IOException("The call to rename a Channel was unsuccessful: \"" + res.getError() + "\"");
        }
        if (!res.hasChannel()) {
            throw new IOException("The call to rename a Channel failed to return the channel data.");
        }
        return res.getChannel();
    }

    public void setDescription(Channel channel) throws IOException {
        throw new IOException("Not Implemented.");
    }

    public void setJoinCode(Channel channel) throws IOException {
        throw new IOException("Not Implemented.");
    }

    public void setPurpose(Channel channel) throws IOException {
        throw new IOException("Not Implemented.");
    }

    public void setReadOnly(Channel channel) throws IOException {
        throw new IOException("Not Implemented.");
    }

    public void setTopic(Channel channel) throws IOException {
        throw new IOException("Not Implemented.");
    }

    public void setType(Channel channel) throws IOException {
        throw new IOException("Not Implemented.");
    }

    public void unarchiveChannel(Channel channel) throws IOException {
        RocketChatClientResponse res = this.callBuilder.buildCall(RocketChatRestApiV1.ChannelsUnarchive, null, channel);
        if (!res.isSuccessful()) {
            throw new IOException("The call to unarchive the Channel was unsuccessful: \"" + res.getError() + "\"");
        }
    }
}

