/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.graph;

import io.intino.cesar.graph.AbstractServer;
import io.intino.cesar.graph.Asset;
import io.intino.cesar.graph.Configuration;
import io.intino.cesar.graph.Consul;
import io.intino.cesar.graph.Device;
import io.intino.cesar.graph.DeviceStatus;
import io.intino.cesar.graph.Perceptible;
import io.intino.cesar.graph.ProcessStatus;
import io.intino.cesar.graph.Server;
import io.intino.cesar.graph.ServerStatus;
import io.intino.cesar.graph.Status;
import io.intino.cesar.graph.User;
import io.intino.cesar.graph.rules.IssueType;
import io.intino.magritte.framework.Concept;
import io.intino.magritte.framework.Graph;
import io.intino.magritte.framework.GraphWrapper;
import io.intino.magritte.framework.Layer;
import io.intino.magritte.framework.Node;
import io.intino.magritte.framework.utils.I18n;
import java.net.URL;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class AbstractGraph
extends GraphWrapper {
    protected Graph graph;
    private List<Perceptible> perceptibleList = new ArrayList<Perceptible>();
    private List<Asset> assetList = new ArrayList<Asset>();
    private List<Server> serverList = new ArrayList<Server>();
    private List<Device> deviceList = new ArrayList<Device>();
    private List<Status> statusList = new ArrayList<Status>();
    private List<Consul> consulList = new ArrayList<Consul>();
    private List<User> userList = new ArrayList<User>();
    private Configuration configuration;
    private List<ServerStatus> serverStatusList = new ArrayList<ServerStatus>();
    private List<DeviceStatus> deviceStatusList = new ArrayList<DeviceStatus>();
    private List<ProcessStatus> processStatusList = new ArrayList<ProcessStatus>();
    private Map<String, Indexer> _index = this._fillIndex();

    public AbstractGraph(Graph graph) {
        this.graph = graph;
        this.graph.i18n().register("Cesar");
    }

    public AbstractGraph(Graph graph, AbstractGraph wrapper) {
        this.graph = graph;
        this.graph.i18n().register("Cesar");
        this.perceptibleList = new ArrayList<Perceptible>(wrapper.perceptibleList);
        this.assetList = new ArrayList<Asset>(wrapper.assetList);
        this.serverList = new ArrayList<Server>(wrapper.serverList);
        this.deviceList = new ArrayList<Device>(wrapper.deviceList);
        this.statusList = new ArrayList<Status>(wrapper.statusList);
        this.consulList = new ArrayList<Consul>(wrapper.consulList);
        this.userList = new ArrayList<User>(wrapper.userList);
        this.configuration = wrapper.configuration;
        this.serverStatusList = new ArrayList<ServerStatus>(wrapper.serverStatusList);
        this.deviceStatusList = new ArrayList<DeviceStatus>(wrapper.deviceStatusList);
        this.processStatusList = new ArrayList<ProcessStatus>(wrapper.processStatusList);
    }

    public <T extends GraphWrapper> T a$(Class<T> t) {
        return this.core$().as(t);
    }

    @Override
    public void update() {
        this._index.values().forEach(v -> v.clear());
        this.graph.rootList().forEach(r -> this.addNode$((Node)r));
    }

    @Override
    protected void addNode$(Node node) {
        for (Concept c : node.conceptList()) {
            if (!this._index.containsKey(c.id())) continue;
            this._index.get(c.id()).add(node);
        }
        if (this._index.containsKey(node.id())) {
            this._index.get(node.id()).add(node);
        }
    }

    @Override
    protected void removeNode$(Node node) {
        for (Concept c : node.conceptList()) {
            if (!this._index.containsKey(c.id())) continue;
            this._index.get(c.id()).remove(node);
        }
        if (this._index.containsKey(node.id())) {
            this._index.get(node.id()).remove(node);
        }
    }

    public URL resourceAsMessage$(String language, String key) {
        return this.graph.loadResource(this.graph.i18n().message(language, key, new Object[0]));
    }

    public List<Perceptible> perceptibleList() {
        return this.perceptibleList;
    }

    public List<Asset> assetList() {
        return this.assetList;
    }

    public List<Server> serverList() {
        return this.serverList;
    }

    public List<Device> deviceList() {
        return this.deviceList;
    }

    public List<Status> statusList() {
        return this.statusList;
    }

    public List<Consul> consulList() {
        return this.consulList;
    }

    public List<User> userList() {
        return this.userList;
    }

    public Configuration configuration() {
        return this.configuration;
    }

    public List<ServerStatus> serverStatusList() {
        return this.serverStatusList;
    }

    public List<DeviceStatus> deviceStatusList() {
        return this.deviceStatusList;
    }

    public List<ProcessStatus> processStatusList() {
        return this.processStatusList;
    }

    public Stream<Perceptible> perceptibleList(Predicate<Perceptible> filter) {
        return this.perceptibleList.stream().filter(filter);
    }

    public Perceptible perceptible(int index) {
        return this.perceptibleList.get(index);
    }

    public Stream<Asset> assetList(Predicate<Asset> filter) {
        return this.assetList.stream().filter(filter);
    }

    public Asset asset(int index) {
        return this.assetList.get(index);
    }

    public Stream<Server> serverList(Predicate<Server> filter) {
        return this.serverList.stream().filter(filter);
    }

    public Server server(int index) {
        return this.serverList.get(index);
    }

    public Stream<Device> deviceList(Predicate<Device> filter) {
        return this.deviceList.stream().filter(filter);
    }

    public Device device(int index) {
        return this.deviceList.get(index);
    }

    public Stream<Status> statusList(Predicate<Status> filter) {
        return this.statusList.stream().filter(filter);
    }

    public Status status(int index) {
        return this.statusList.get(index);
    }

    public Stream<Consul> consulList(Predicate<Consul> filter) {
        return this.consulList.stream().filter(filter);
    }

    public Consul consul(int index) {
        return this.consulList.get(index);
    }

    public Stream<User> userList(Predicate<User> filter) {
        return this.userList.stream().filter(filter);
    }

    public User user(int index) {
        return this.userList.get(index);
    }

    public Stream<ServerStatus> serverStatusList(Predicate<ServerStatus> filter) {
        return this.serverStatusList.stream().filter(filter);
    }

    public ServerStatus serverStatus(int index) {
        return this.serverStatusList.get(index);
    }

    public Stream<DeviceStatus> deviceStatusList(Predicate<DeviceStatus> filter) {
        return this.deviceStatusList.stream().filter(filter);
    }

    public DeviceStatus deviceStatus(int index) {
        return this.deviceStatusList.get(index);
    }

    public Stream<ProcessStatus> processStatusList(Predicate<ProcessStatus> filter) {
        return this.processStatusList.stream().filter(filter);
    }

    public ProcessStatus processStatus(int index) {
        return this.processStatusList.get(index);
    }

    public Graph core$() {
        return this.graph;
    }

    public I18n i18n$() {
        return this.graph.i18n();
    }

    public Create create() {
        return new Create("Misc", null);
    }

    public Create create(String stash) {
        return new Create(stash, null);
    }

    public Create create(String stash, String name) {
        return new Create(stash, name);
    }

    public Clear clear() {
        return new Clear();
    }

    private HashMap<String, Indexer> _fillIndex() {
        HashMap<String, Indexer> map = new HashMap<String, Indexer>();
        map.put("Perceptible", new Indexer(node -> this.perceptibleList.add(node.as(Perceptible.class)), node -> this.perceptibleList.remove(node.as(Perceptible.class)), () -> this.perceptibleList.clear()));
        map.put("Asset", new Indexer(node -> this.assetList.add(node.as(Asset.class)), node -> this.assetList.remove(node.as(Asset.class)), () -> this.assetList.clear()));
        map.put("Server", new Indexer(node -> this.serverList.add(node.as(Server.class)), node -> this.serverList.remove(node.as(Server.class)), () -> this.serverList.clear()));
        map.put("Device", new Indexer(node -> this.deviceList.add(node.as(Device.class)), node -> this.deviceList.remove(node.as(Device.class)), () -> this.deviceList.clear()));
        map.put("Status", new Indexer(node -> this.statusList.add(node.as(Status.class)), node -> this.statusList.remove(node.as(Status.class)), () -> this.statusList.clear()));
        map.put("Consul", new Indexer(node -> this.consulList.add(node.as(Consul.class)), node -> this.consulList.remove(node.as(Consul.class)), () -> this.consulList.clear()));
        map.put("User", new Indexer(node -> this.userList.add(node.as(User.class)), node -> this.userList.remove(node.as(User.class)), () -> this.userList.clear()));
        map.put("Configuration", new Indexer(node -> {
            this.configuration = node.as(Configuration.class);
        }, node -> {
            this.configuration = null;
        }, () -> {
            this.configuration = null;
        }));
        map.put("ServerStatus", new Indexer(node -> this.serverStatusList.add(node.as(ServerStatus.class)), node -> this.serverStatusList.remove(node.as(ServerStatus.class)), () -> this.serverStatusList.clear()));
        map.put("DeviceStatus", new Indexer(node -> this.deviceStatusList.add(node.as(DeviceStatus.class)), node -> this.deviceStatusList.remove(node.as(DeviceStatus.class)), () -> this.deviceStatusList.clear()));
        map.put("ProcessStatus", new Indexer(node -> this.processStatusList.add(node.as(ProcessStatus.class)), node -> this.processStatusList.remove(node.as(ProcessStatus.class)), () -> this.processStatusList.clear()));
        return map;
    }

    static interface IndexClear {
        public void clear();
    }

    static interface Remove {
        public void remove(Node var1);
    }

    static interface Add {
        public void add(Node var1);
    }

    public static class Indexer {
        Add add;
        Remove remove;
        IndexClear clear;

        public Indexer(Add add, Remove remove, IndexClear clear) {
            this.add = add;
            this.remove = remove;
            this.clear = clear;
        }

        void add(Node node) {
            this.add.add(node);
        }

        void remove(Node node) {
            this.remove.remove(node);
        }

        void clear() {
            this.clear.clear();
        }
    }

    public class Clear {
        public void asset(Predicate<Asset> filter) {
            new ArrayList<Asset>(AbstractGraph.this.assetList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void server(Predicate<Server> filter) {
            new ArrayList<Server>(AbstractGraph.this.serverList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void device(Predicate<Device> filter) {
            new ArrayList<Device>(AbstractGraph.this.deviceList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void consul(Predicate<Consul> filter) {
            new ArrayList<Consul>(AbstractGraph.this.consulList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void user(Predicate<User> filter) {
            new ArrayList<User>(AbstractGraph.this.userList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void serverStatus(Predicate<ServerStatus> filter) {
            new ArrayList<ServerStatus>(AbstractGraph.this.serverStatusList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void deviceStatus(Predicate<DeviceStatus> filter) {
            new ArrayList<DeviceStatus>(AbstractGraph.this.deviceStatusList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void processStatus(Predicate<ProcessStatus> filter) {
            new ArrayList<ProcessStatus>(AbstractGraph.this.processStatusList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public class Create {
        private final String stash;
        private final String name;

        public Create(String stash, String name) {
            this.stash = stash;
            this.name = name;
        }

        public Asset asset(String label, List<IssueType> activeIssueSensors) {
            Asset newElement = AbstractGraph.this.graph.createRoot(Asset.class, this.stash, this.name).a$(Asset.class);
            newElement.core$().set(newElement, "label", Collections.singletonList(label));
            newElement.core$().set(newElement, "activeIssueSensors", activeIssueSensors);
            return newElement;
        }

        public Server server(String label, String ip, String architecture, String os, String jvm, String appsWorkspace, AbstractServer.Scope scope) {
            Server newElement = AbstractGraph.this.graph.createRoot(Server.class, this.stash, this.name).a$(Server.class);
            newElement.core$().set(newElement, "label", Collections.singletonList(label));
            newElement.core$().set(newElement, "ip", Collections.singletonList(ip));
            newElement.core$().set(newElement, "architecture", Collections.singletonList(architecture));
            newElement.core$().set(newElement, "os", Collections.singletonList(os));
            newElement.core$().set(newElement, "jvm", Collections.singletonList(jvm));
            newElement.core$().set(newElement, "appsWorkspace", Collections.singletonList(appsWorkspace));
            newElement.core$().set(newElement, "scope", Collections.singletonList(scope));
            return newElement;
        }

        public Device device(String label) {
            Device newElement = AbstractGraph.this.graph.createRoot(Device.class, this.stash, this.name).a$(Device.class);
            newElement.core$().set(newElement, "label", Collections.singletonList(label));
            return newElement;
        }

        public Consul consul(String version) {
            Consul newElement = AbstractGraph.this.graph.createRoot(Consul.class, this.stash, this.name).a$(Consul.class);
            newElement.core$().set(newElement, "version", Collections.singletonList(version));
            return newElement;
        }

        public User user(String fullName, String mail, String token) {
            User newElement = AbstractGraph.this.graph.createRoot(User.class, this.stash, this.name).a$(User.class);
            newElement.core$().set(newElement, "fullName", Collections.singletonList(fullName));
            newElement.core$().set(newElement, "mail", Collections.singletonList(mail));
            newElement.core$().set(newElement, "token", Collections.singletonList(token));
            return newElement;
        }

        public Configuration configuration() {
            Configuration newElement = AbstractGraph.this.graph.createRoot(Configuration.class, this.stash, this.name).a$(Configuration.class);
            return newElement;
        }

        public ServerStatus serverStatus(Instant ts, double cpuUsage, double memoryUsage, double diskUsage, int inboundConnections, int outboundConnections, double kernelTemperature, double externalTemperature) {
            ServerStatus newElement = AbstractGraph.this.graph.createRoot(ServerStatus.class, this.stash, this.name).a$(ServerStatus.class);
            newElement.core$().set(newElement, "ts", Collections.singletonList(ts));
            newElement.core$().set(newElement, "cpuUsage", Collections.singletonList(cpuUsage));
            newElement.core$().set(newElement, "memoryUsage", Collections.singletonList(memoryUsage));
            newElement.core$().set(newElement, "diskUsage", Collections.singletonList(diskUsage));
            newElement.core$().set(newElement, "inboundConnections", Collections.singletonList(inboundConnections));
            newElement.core$().set(newElement, "outboundConnections", Collections.singletonList(outboundConnections));
            newElement.core$().set(newElement, "kernelTemperature", Collections.singletonList(kernelTemperature));
            newElement.core$().set(newElement, "externalTemperature", Collections.singletonList(externalTemperature));
            return newElement;
        }

        public DeviceStatus deviceStatus(Instant ts, double temperature, double battery, double cpuUsage, boolean isPlugged, boolean isScreenOn) {
            DeviceStatus newElement = AbstractGraph.this.graph.createRoot(DeviceStatus.class, this.stash, this.name).a$(DeviceStatus.class);
            newElement.core$().set(newElement, "ts", Collections.singletonList(ts));
            newElement.core$().set(newElement, "temperature", Collections.singletonList(temperature));
            newElement.core$().set(newElement, "battery", Collections.singletonList(battery));
            newElement.core$().set(newElement, "cpuUsage", Collections.singletonList(cpuUsage));
            newElement.core$().set(newElement, "isPlugged", Collections.singletonList(isPlugged));
            newElement.core$().set(newElement, "isScreenOn", Collections.singletonList(isScreenOn));
            return newElement;
        }

        public ProcessStatus processStatus(Instant ts, double cpuUsage, double memoryUsage, int threads, double workingDirectorySize, double workingDirectoryTotalSize) {
            ProcessStatus newElement = AbstractGraph.this.graph.createRoot(ProcessStatus.class, this.stash, this.name).a$(ProcessStatus.class);
            newElement.core$().set(newElement, "ts", Collections.singletonList(ts));
            newElement.core$().set(newElement, "cpuUsage", Collections.singletonList(cpuUsage));
            newElement.core$().set(newElement, "memoryUsage", Collections.singletonList(memoryUsage));
            newElement.core$().set(newElement, "threads", Collections.singletonList(threads));
            newElement.core$().set(newElement, "workingDirectorySize", Collections.singletonList(workingDirectorySize));
            newElement.core$().set(newElement, "workingDirectoryTotalSize", Collections.singletonList(workingDirectoryTotalSize));
            return newElement;
        }
    }
}

