/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.checkers;

import io.intino.cesar.box.CesarBox;
import io.intino.cesar.graph.Process;
import io.intino.cesar.graph.rules.IssueType;

public class ProcessChecker {
    private final Process process;
    private final CesarBox box;

    public ProcessChecker(Process process, CesarBox box) {
        this.process = process;
        this.box = box;
    }

    public void check() {
        if (this.process.status() == null) {
            return;
        }
        this.checkStopped();
        this.process.save$();
    }

    private void checkStopped() {
        if (this.process.isStopped() && !this.process.currentIssues().contains(IssueType.Stopped)) {
            this.box.issueDispatcher().onIssue(this.process, IssueType.Stopped);
        } else if (!this.process.isStopped() && this.process.currentIssues().contains(IssueType.Stopped)) {
            this.box.issueDispatcher().onIssueFinish(this.process, IssueType.Stopped);
        }
    }
}

