/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.infrastructure.mounters.handlers;

import io.intino.alexandria.logger.Logger;
import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.infrastructure.mounters.handlers.InfrastructureHandler;
import io.intino.cesar.datahub.events.cesar.InfrastructureOperation;
import io.intino.cesar.graph.Device;
import io.intino.cesar.graph.rules.IssueType;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class DeviceHandler {

    public static class SetNotifications
    extends InfrastructureHandler {
        public SetNotifications(CesarBox box, InfrastructureOperation operation) {
            super(box, operation);
        }

        @Override
        public void execute() {
            Device device = this.cesar.core$().load(this.objectID()).as(Device.class);
            ArrayList<IssueType> list = new ArrayList<IssueType>();
            if ("true".equals(this.parameters().get(0))) {
                list.add(IssueType.Unplugged);
            }
            if ("true".equals(this.parameters().get(1))) {
                list.add(IssueType.HighTemperature);
            }
            if ("true".equals(this.parameters().get(2))) {
                list.add(IssueType.DrainingBattery);
            }
            if ("true".equals(this.parameters().get(3))) {
                list.add(IssueType.RunningOutBattery);
            }
            if ("true".equals(this.parameters().get(4))) {
                list.add(IssueType.Disconnected);
            }
            device.activeIssueSensors().clear();
            device.activeIssueSensors().addAll(list);
            device.save$();
        }
    }

    public static class Upgrade
    extends InfrastructureHandler {
        public Upgrade(CesarBox box, InfrastructureOperation operation) {
            super(box, operation);
        }

        @Override
        public void execute() {
            Device device = this.cesar.device(this.objectID());
            device.consul().version(this.parameters().get(0));
            device.save$();
        }
    }

    public static class Rename
    extends InfrastructureHandler {
        public Rename(CesarBox box, InfrastructureOperation operation) {
            super(box, operation);
        }

        @Override
        public void execute() {
            Device device = this.cesar.core$().load(this.objectID()).as(Device.class);
            device.label(this.parameters().get(0));
            device.save$();
        }
    }

    public static class Remove
    extends InfrastructureHandler {
        public Remove(CesarBox box, InfrastructureOperation operation) {
            super(box, operation);
        }

        @Override
        public void execute() {
            this.cesar.core$().load(this.objectID()).as(Device.class).delete$();
        }
    }

    public static class Add
    extends InfrastructureHandler {
        public Add(CesarBox box, InfrastructureOperation operation) {
            super(box, operation);
        }

        @Override
        public void execute() {
            Device device = this.cesar.create("infrastructure/devices/" + this.objectID(), this.objectID()).device(this.parameters().get(0));
            device.create().consul("1.0.0");
            device.create().screen(null);
            device.create().temperature(0.0, 0.0);
            String label = this.find(device.name$());
            if (label != null) {
                device.label(label);
            }
            try {
                device.save$();
            }
            catch (Exception e) {
                Logger.error(e);
            }
        }

        private String find(String id) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(new BufferedInputStream(this.getClass().getResourceAsStream("/devices-id.csv"))));
            String label = reader.lines().filter(l -> l.startsWith(id + ";")).findFirst().orElse(null);
            if (label != null) {
                label = label.replace(id + ";", "");
            }
            return label;
        }
    }
}

