/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.infrastructure.mounters;

import io.intino.alexandria.event.Event;
import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.infrastructure.mounters.handlers.ProcessHandler;
import io.intino.cesar.box.mounters.Mounter;
import io.intino.cesar.box.schemas.ProcessDeployment;
import io.intino.cesar.checkers.ServerChecker;
import io.intino.cesar.datahub.events.cesar.InfrastructureOperation;
import io.intino.cesar.datahub.events.consul.server.ServerBoot;
import io.intino.cesar.datahub.events.consul.server.ServerInfo;
import io.intino.cesar.datahub.events.consul.server.ServerLog;
import io.intino.cesar.datahub.events.consul.server.ServerStatus;
import io.intino.cesar.graph.AbstractServer;
import io.intino.cesar.graph.Process;
import io.intino.cesar.graph.Server;
import java.util.stream.Collectors;

public class ServerMounter
implements Mounter {
    private final CesarBox box;

    public ServerMounter(CesarBox box) {
        this.box = box;
    }

    public void handle(ServerBoot boot) {
        AbstractServer.Scope scope;
        Server server = this.findServer(this.box, boot.id());
        AbstractServer.Scope scope2 = scope = boot.scope() == null ? AbstractServer.Scope.DEV : AbstractServer.Scope.valueOf(boot.scope().toUpperCase());
        if (server == null) {
            server = this.box.graph().create("infrastructure/servers/" + boot.id(), boot.id()).server(boot.id(), boot.ip(), boot.architecture(), boot.os(), boot.jvm(), boot.appsWorkspace(), scope);
            server.create().cPU(boot.cores(), 3000.0);
            server.create().hDD(boot.diskSize().longValue(), 7200);
            server.create().memory(boot.memorySize().longValue(), 4000.0);
            server.create().serverConsul(boot.version());
        } else {
            server.cPU().cores(boot.cores());
            server.scope(scope);
            server.ip(boot.ip());
            server.appsWorkspace(boot.appsWorkspace());
            server.hDD().capacity(boot.diskSize().longValue());
            if (server.memory() == null) {
                server.create().memory(boot.memorySize().longValue(), 4000.0);
            } else {
                server.memory().capacity(boot.memorySize().longValue());
            }
            server.serverConsul().version(boot.version());
        }
        server.lastBoot(boot.ts());
        server.save$();
        for (ServerBoot.ProcessInfo info : boot.processInfoList()) {
            Process process = this.box.graph().process(server.name$(), info.id());
            if (process != null) continue;
            ProcessDeployment processDeployment = this.operationFrom(info, server);
            new ProcessHandler.Add(this.box, new InfrastructureOperation(), processDeployment).execute();
            new ProcessHandler.NewDeployment(this.box, new InfrastructureOperation().objectID(processDeployment.groupId() + ":" + processDeployment.artifactId()).objectType("Process"), processDeployment).execute();
        }
    }

    private ProcessDeployment operationFrom(ServerBoot.ProcessInfo info, Server server) {
        String[] artifact = info.artifact().split(":");
        return new ProcessDeployment().destinationServer(server.name$()).jmxPort(info.jmxPort()).groupId(artifact[0]).artifactId(artifact[1]).version(artifact[2]).artifactoryList(info.artifactoryList().stream().map(a -> new ProcessDeployment.Artifactory().user(a.user()).password(a.password()).url(a.url()).id(a.id())).collect(Collectors.toList())).requirements(new ProcessDeployment.Requirements().minMemory(info.minMemory())).packaging(new ProcessDeployment.Packaging().classpathPrefix(info.classpathPrefix()).parameterList(info.parameterList().stream().map(a -> new ProcessDeployment.Packaging.Parameter().name(a.name()).value(a.value())).collect(Collectors.toList())));
    }

    public void handle(ServerInfo info) {
        if (info != null) {
            Server server = this.findServer(this.box, info.id());
            if (server == null) {
                return;
            }
            server.ip(info.ip());
            server.hDD().capacity(info.diskSize().longValue());
            server.memory().capacity(info.memorySize().longValue());
            server.save$();
        }
    }

    public void handle(ServerStatus status) {
        Server server = this.findServer(this.box, status.id());
        if (server == null || server.currentStatus() != null && server.currentStatus().ts().isAfter(status.ts())) {
            return;
        }
        server.add(status);
        new ServerChecker(server, this.box).check();
    }

    public void handle(ServerLog event) {
    }

    @Override
    public void handle(Event event) {
        if (event instanceof ServerInfo) {
            this.handle((ServerInfo)event);
        } else if (event instanceof ServerBoot) {
            this.handle((ServerBoot)event);
        } else if (event instanceof ServerStatus) {
            this.handle((ServerStatus)event);
        } else if (event instanceof ServerLog) {
            this.handle((ServerLog)event);
        }
    }

    protected Server findServer(CesarBox box, String name) {
        return box.graph().serverList(s -> s.name$().equals(name.replace(".", "-"))).findFirst().orElse(null);
    }
}

