/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.infrastructure.mounters;

import io.intino.alexandria.logger.Logger;
import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.infrastructure.mounters.handlers.DeviceHandler;
import io.intino.cesar.box.infrastructure.mounters.handlers.Infrastructure;
import io.intino.cesar.box.infrastructure.mounters.handlers.InfrastructureHandler;
import io.intino.cesar.box.infrastructure.mounters.handlers.Perceptible;
import io.intino.cesar.box.infrastructure.mounters.handlers.ProcessHandler;
import io.intino.cesar.box.infrastructure.mounters.handlers.ServerHandler;
import io.intino.cesar.datahub.events.cesar.InfrastructureOperation;
import java.util.HashMap;
import java.util.Map;

public class InfrastructureOperationHandlerFactory {
    private static Map<String, HandlerCreator> handlerMap = new HashMap<String, HandlerCreator>();

    public static InfrastructureHandler get(CesarBox box, InfrastructureOperation operation) {
        try {
            HandlerCreator handlerCreator = handlerMap.get((operation.operation() + ";" + operation.objectType()).toLowerCase());
            if (handlerCreator == null) {
                throw new Exception("Handler not found");
            }
            return handlerCreator.build(box, operation);
        }
        catch (Throwable e) {
            Logger.error("Error handling event. " + operation.toString() + "." + e.getMessage(), e);
            return null;
        }
    }

    static {
        handlerMap.put("add;device", DeviceHandler.Add::new);
        handlerMap.put("add;process", ProcessHandler.Add::new);
        handlerMap.put("remove;device", DeviceHandler.Remove::new);
        handlerMap.put("remove;process", ProcessHandler.Remove::new);
        handlerMap.put("remove;server", ServerHandler.Remove::new);
        handlerMap.put("rename;device", DeviceHandler.Rename::new);
        handlerMap.put("rename;process", ProcessHandler.Rename::new);
        handlerMap.put("rename;server", ServerHandler.Rename::new);
        handlerMap.put("upgrade;device", DeviceHandler.Upgrade::new);
        handlerMap.put("sshchain;server", ServerHandler.SshChain::new);
        handlerMap.put("setnotifications;device", DeviceHandler.SetNotifications::new);
        handlerMap.put("newdeployment;process", ProcessHandler.NewDeployment::new);
        handlerMap.put("changeparameter;process", ProcessHandler.ChangeParameter::new);
        handlerMap.put("changestatus;process", ProcessHandler.ChangeStatus::new);
        handlerMap.put("setresponsibles;process", Perceptible.SetResponsibles::new);
        handlerMap.put("setresponsibles;server", Perceptible.SetResponsibles::new);
        handlerMap.put("setresponsibles;feeder", Perceptible.SetResponsibles::new);
        handlerMap.put("setresponsibles;device", Perceptible.SetResponsibles::new);
        handlerMap.put("notifications;configuration", Infrastructure.NotificationsConfiguration::new);
    }

    private static interface HandlerCreator {
        public InfrastructureHandler build(CesarBox var1, InfrastructureOperation var2);
    }
}

