/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.infrastructure.mounters;

import io.intino.alexandria.event.Event;
import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.infrastructure.mounters.handlers.DeviceHandler;
import io.intino.cesar.box.mounters.Mounter;
import io.intino.cesar.checkers.DeviceChecker;
import io.intino.cesar.datahub.events.cesar.InfrastructureOperation;
import io.intino.cesar.datahub.events.consul.device.DeviceBoot;
import io.intino.cesar.datahub.events.consul.device.DeviceCrash;
import io.intino.cesar.datahub.events.consul.device.DeviceStatus;
import io.intino.cesar.graph.Asset;
import io.intino.cesar.graph.CesarGraph;
import io.intino.cesar.graph.Device;
import java.time.Instant;
import java.util.Collections;

public class DeviceMounter
implements Mounter {
    private final CesarBox box;

    public DeviceMounter(CesarBox box) {
        this.box = box;
    }

    public void handle(DeviceBoot boot) {
        if (boot == null) {
            return;
        }
        Device device = this.findDevice(this.box, boot.deviceId());
        if (device == null) {
            new DeviceHandler.Add(this.box, new InfrastructureOperation().ts(Instant.now()).operation("add").user("cesar").objectType("device").objectID(boot.deviceId()).parameters(Collections.singletonList(boot.deviceId()))).execute();
            device = this.findDevice(this.box, boot.deviceId());
        }
        if (boot.androidVersion() != null) {
            device.androidVersion(boot.androidVersion());
        }
        if (boot.consulVersion() != null) {
            device.consul().version(boot.consulVersion());
        }
        device.lastBoot(boot.ts());
        device.save$();
    }

    public void handle(DeviceStatus status) {
        if (status == null) {
            return;
        }
        Device device = this.findDevice(this.box, status.deviceId());
        if (device == null) {
            return;
        }
        device.add(status);
        new DeviceChecker(device, this.box).check();
    }

    public void handle(DeviceCrash crash) {
        Device device = this.findDevice(this.box, crash.deviceId());
        if (device == null) {
            return;
        }
    }

    Device findDevice(CesarBox box, String name) {
        CesarGraph cesar = box.graph();
        Asset device = cesar.assetList(u -> u instanceof Device).filter(unit -> unit.name$().equals(name)).findFirst().orElse(null);
        return (Device)device;
    }

    @Override
    public void handle(Event event) {
        if (event instanceof DeviceBoot) {
            this.handle((DeviceBoot)event);
        }
        if (event instanceof DeviceStatus) {
            this.handle((DeviceStatus)event);
        }
        if (event instanceof DeviceCrash) {
            this.handle((DeviceCrash)event);
        }
    }
}

