/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.bot;

import io.intino.alexandria.exceptions.BadRequest;
import io.intino.alexandria.logger.Logger;
import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.MessageManager;
import io.intino.cesar.box.accessors.ServerProcessAccessor;
import io.intino.cesar.box.accessors.ServerProcessDeployer;
import io.intino.cesar.box.actions.GetProcessLogAction;
import io.intino.cesar.box.bot.ChatSection;
import io.intino.cesar.box.bot.LineChartBuilder;
import io.intino.cesar.box.bot.RestBot;
import io.intino.cesar.box.bot.helpers.BotMessageFormatter;
import io.intino.cesar.box.schemas.ProcessDeployment;
import io.intino.cesar.datahub.events.OperationResult;
import io.intino.cesar.datahub.events.Operations;
import io.intino.cesar.datahub.events.consul.process.ProcessLog;
import io.intino.cesar.datahub.events.consul.process.ProcessStatus;
import io.intino.cesar.graph.Artifact;
import io.intino.cesar.graph.Process;
import io.intino.cesar.graph.Server;
import io.intino.cesar.graph.User;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;

public class ServerProcessContext
extends ChatSection {
    public ServerProcessContext(CesarBox box) {
        super(box);
    }

    public String status(RestBot.MessageProperties properties) {
        Process process = this.findProcess(properties);
        if (process == null) {
            return "No process has been connected";
        }
        ProcessStatus status = this.box.serverProcessAccessor(process).status();
        if (status != null) {
            return this.icon(process.deployedServer()) + "*" + process.label() + " v." + process.currentDeployment().artifact().version() + "*" + " " + BotMessageFormatter.format(status, process, properties.timeZone());
        }
        return "Process couldn't be requested";
    }

    public String name(RestBot.MessageProperties properties, String newName) {
        Process process = this.findProcess(properties);
        if (process == null) {
            return "No process has been connected";
        }
        this.box.committer().commit(MessageManager.infrastructureOperationMessage("rename", properties.username(), process, newName));
        return ":ok_hand:";
    }

    public String tail(RestBot.MessageProperties properties, String numLines) {
        int limit = numLines.isEmpty() ? 10 : Integer.parseInt(numLines);
        Process process = this.findProcess(properties);
        if (process == null) {
            return "No process has been connected";
        }
        ProcessLog log = this.box.serverProcessAccessor(process).log();
        if (log != null) {
            String value = log.value();
            if (value.isEmpty()) {
                value = this.readLocalLog(process);
            }
            return this.format(value, limit);
        }
        return this.format(this.readLocalLog(process), limit);
    }

    public Object log(RestBot.MessageProperties properties) {
        Process process = this.findProcess(properties);
        if (process == null) {
            return "No process has been connected";
        }
        ProcessLog log = this.box.serverProcessAccessor(process).log();
        if (log != null) {
            String value = log.value();
            if (!value.isEmpty()) {
                return new RestBot.Attachment(value.getBytes(), process.label() + ".txt", process.label() + ".txt", RestBot.Attachment.Type.File);
            }
            return this.readLocalLog(process);
        }
        return "*Impossible to retrieve log*";
    }

    public Object history(RestBot.MessageProperties properties, String metric) {
        Process process = this.findProcess(properties);
        if (!(metric.equalsIgnoreCase("memory") || metric.equalsIgnoreCase("cpu") || metric.equalsIgnoreCase("threads"))) {
            return "Metric not found";
        }
        if (process == null) {
            return "No process has been connected";
        }
        BufferedImage image = LineChartBuilder.build(process.processStatusList(), this.mapper(metric), process.identifier() + ":" + metric, this.unit(metric), properties.timeZone());
        if (image == null) {
            return "*Impossible to create history Image*";
        }
        String title = process.identifier() + "_" + metric + ".png";
        return new RestBot.Attachment(this.bytes(image), "", title, RestBot.Attachment.Type.Image);
    }

    public String subscribeLog(RestBot.MessageProperties properties) {
        return "";
    }

    public String stopLog(RestBot.MessageProperties properties) {
        return "";
    }

    public String responsibles(RestBot.MessageProperties properties) {
        Process process = this.findProcess(properties);
        if (process == null) {
            return "No process has been connected";
        }
        StringBuilder builder = new StringBuilder();
        for (User responsible : process.responsibles()) {
            builder.append(responsible.name$()).append(" ").append(responsible.mail()).append("\n");
        }
        String result = builder.toString();
        return result.isEmpty() ? "No responsibles are registered." : result;
    }

    public String parameter(RestBot.MessageProperties properties, String name, String value) {
        Process process = this.findProcess(properties);
        if (process == null) {
            return "No process has been connected";
        }
        Process.Deployment deployment = process.currentDeployment();
        if (deployment.parameterList().stream().noneMatch(p -> p.name().equals(name))) {
            return "Parameter not found";
        }
        if (value.startsWith("<")) {
            value = value.substring(1, value.length() - 1);
        }
        this.box.committer().commit(MessageManager.infrastructureOperationMessage("changeparameter", properties.username(), process, name, value));
        return ":ok_hand:";
    }

    public String start(RestBot.MessageProperties properties) {
        Process process = this.findProcess(properties);
        if (process == null) {
            return "No process has been connected";
        }
        Boolean success = this.box.serverProcessAccessor(process).start();
        if (success.booleanValue()) {
            this.box.committer().commit(MessageManager.processMessage("changestatus", properties.username(), process, "start"));
            return this.icon(process.deployedServer()) + "*" + process.label() + "* started on " + process.consul().core$().ownerAs(Server.class).label();
        }
        return "Process couldn't be requested";
    }

    public String debug(RestBot.MessageProperties properties) {
        Process process = this.findProcess(properties);
        if (process == null) {
            return "No process has been connected";
        }
        Boolean success = this.box.serverProcessAccessor(process).debug();
        if (success.booleanValue()) {
            this.box.committer().commit(MessageManager.processMessage("changestatus", properties.username(), process, "debug"));
            return this.icon(process.deployedServer()) + "*" + process.label() + "* started on debug. Open console and start tunnel to port: `" + process.debugPort() + "`";
        }
        return "Process couldn't be requested";
    }

    public String stop(RestBot.MessageProperties properties) {
        Process process = this.findProcess(properties);
        if (process == null) {
            return "No process has been connected";
        }
        Boolean success = this.box.serverProcessAccessor(process).stop();
        if (success.booleanValue()) {
            this.box.committer().commit(MessageManager.processMessage("changestatus", properties.username(), process, "stop"));
        }
        return success != false ? this.icon(process.deployedServer()) + "*" + process.label() + "* stopped on " + process.consul().core$().ownerAs(Server.class).label() : "Process couldn't be requested";
    }

    public String restart(RestBot.MessageProperties properties) {
        Process process = this.findProcess(properties);
        if (process == null) {
            return "No process has been connected";
        }
        Boolean success = this.box.serverProcessAccessor(process).restart();
        if (success.booleanValue()) {
            this.box.committer().commit(MessageManager.processMessage("changestatus", properties.username(), process, "restart"));
            return this.icon(process.deployedServer()) + "*" + process.label() + "* restarted on " + process.consul().core$().ownerAs(Server.class).label();
        }
        return "Process couldn't be requested";
    }

    public String parameters(RestBot.MessageProperties properties) {
        Process process = this.findProcess(properties);
        if (process == null) {
            return "No process has been connected";
        }
        if (process.deploymentList().isEmpty()) {
            return "no deployments yet";
        }
        Process.Deployment deployment = process.deploymentList().get(process.deploymentList().size() - 1);
        return deployment.parameterList().stream().map((? super T p) -> p.name$() + " = " + p.value()).collect(Collectors.joining("\n"));
    }

    public String setResponsibles(RestBot.MessageProperties properties, String[] users) {
        List<String> newResponsibleNames = Arrays.asList(users);
        Process process = this.findProcess(properties);
        if (process == null) {
            return "No process has been connected";
        }
        List responsibles = this.graph().userList(r -> newResponsibleNames.contains(r.name$())).collect(Collectors.toList());
        if (responsibles.size() != newResponsibleNames.size()) {
            return "Some responsible hasn't been found";
        }
        this.box.committer().commit(MessageManager.infrastructureOperationMessage("setResponsibles", properties.username(), process, users));
        return ":ok_hand:";
    }

    private Process findProcess(RestBot.MessageProperties properties) {
        RestBot.Context context = properties.context();
        if (context == null) {
            return null;
        }
        Server server = this.graph().findServerByName(context.getObjects()[0]);
        String processName = context.getObjects()[1];
        Process process = this.graph().findProcessByName(server.name$(), processName);
        return process == null ? this.graph().findProcessByPosition(server.name$(), context.getObjects()[1]) : process;
    }

    public String operations(RestBot.MessageProperties properties) {
        Process process = this.findProcess(properties);
        if (process == null) {
            return "";
        }
        ServerProcessAccessor commander = this.box.serverProcessAccessor(process);
        List<Operations.Operation> result = commander.operations();
        if (result != null) {
            process.processNewOperations(result);
            process.save$();
            StringBuilder builder = new StringBuilder(this.icon(process.deployedServer()) + process.label() + ">\n");
            for (Operations.Operation operation : result) {
                builder.append("*").append(operation.name()).append("*");
                operation.parameters().forEach(p -> builder.append("`").append((String)p).append("`"));
                if (!operation.description().isEmpty()) {
                    builder.append(" : ").append(operation.description());
                }
                builder.append("\n");
            }
            return builder.toString();
        }
        return "Process couldn't be requested";
    }

    public Object invoke(RestBot.MessageProperties properties, String operation, String[] args) {
        Process process = this.findProcess(properties);
        if (process == null) {
            return "Process not found";
        }
        ServerProcessAccessor commander = this.box.serverProcessAccessor(process);
        List<Operations.Operation> operations = commander.operations();
        if (operations == null) {
            return "Process couldn't be requested";
        }
        Operations.Operation toExecute = operations.stream().filter(op -> op.name().equals(operation)).findFirst().orElse(null);
        if (toExecute == null) {
            return "Operation not found";
        }
        ArrayList<String> parameters = new ArrayList<String>(Arrays.asList(args));
        try {
            OperationResult result;
            if (properties.attachment() != null) {
                parameters.add(new String(properties.attachment().getInputStream().readAllBytes(), StandardCharsets.UTF_8));
            }
            if ((result = commander.operation(new Operations.Operation().processId(process.identifier()).name(operation).parameters(parameters.subList(1, parameters.size())))) != null) {
                String remarks = result.remarks();
                if (result.remarksIsFile().booleanValue()) {
                    String fileName = process.label() + "_" + operation + (remarks.startsWith("<html>") ? ".html" : ".txt");
                    return new RestBot.Attachment(remarks.getBytes(), fileName, fileName, RestBot.Attachment.Type.File);
                }
                return this.icon(process.deployedServer()) + "*" + process.label() + "* " + remarks;
            }
        }
        catch (IOException e) {
            Logger.error(e);
        }
        return "Process couldn't be requested";
    }

    public String ssh(RestBot.MessageProperties properties) {
        Process process = this.findProcess(properties);
        if (process == null) {
            return "Process not found";
        }
        Server server = this.graph().serverOf(process);
        if (server == null) {
            return "Server not found";
        }
        Server.RemoteConnection connection = server.remoteConnection();
        if (connection == null) {
            return "Remote connection chain is not defined yet";
        }
        return "`ssh -p " + connection.port() + connection.user() + "@" + connection.url() + "`";
    }

    public String deployments(RestBot.MessageProperties properties) {
        Process process = this.findProcess(properties);
        if (process == null) {
            return "Process not found";
        }
        List<Process.Deployment> deployments = process.deploymentList();
        if (deployments.isEmpty()) {
            return "No deployments";
        }
        StringBuilder builder = new StringBuilder();
        for (int j = 0; j < deployments.size(); ++j) {
            Process.Deployment d = deployments.get(j);
            builder.append(j + 1).append(") *").append(d.artifact().identifier()).append("* at ").append(BotMessageFormatter.formatInstant(d.created(), properties.timeZone())).append("\n");
        }
        return builder.toString();
    }

    public String rollback(RestBot.MessageProperties properties, String position) {
        Process process = this.findProcess(properties);
        if (process == null) {
            return "Process not found";
        }
        Process.Deployment selected = this.graph().deploymentByPosition(process.deploymentList(), position);
        if (selected == null) {
            return "Deployment not found";
        }
        if (selected.equals(process.currentDeployment())) {
            return "This is current deployment";
        }
        new ServerProcessDeployer(this.box, process.consul(), this.deploymentSchema(process, selected), this.userFrom(properties)).deploy();
        return "Launching new deployment";
    }

    private ProcessDeployment deploymentSchema(Process process, Process.Deployment d) {
        ProcessDeployment deployment = new ProcessDeployment().groupId(d.artifact().group()).artifactId(d.artifact().artifactId()).version(d.artifact().version());
        return deployment.destinationServer(process.consul().core$().ownerAs(Server.class).name$()).artifactoryList(this.map(d.artifact().artifactoryList())).jmxPort(process.consul().jmxPort()).jvmOptions(d.jvmOptions()).packaging(this.packaging(d)).requirements(new ProcessDeployment.Requirements().hdd(d.prerequisites().hdd()).minMemory(d.prerequisites().minMemory()).maxMemory(d.prerequisites().maxMemory()));
    }

    private User userFrom(RestBot.MessageProperties properties) {
        return this.graph().userList(u -> u.name$().equals(properties.username())).findFirst().orElse(null);
    }

    private ProcessDeployment.Packaging packaging(Process.Deployment deployment) {
        ProcessDeployment.Packaging packaging = new ProcessDeployment.Packaging();
        deployment.parameterList().forEach(p -> packaging.parameterList().add(new ProcessDeployment.Packaging.Parameter().name(p.name()).value(p.value())));
        packaging.classpathPrefix(deployment.artifact().classpathPrefix());
        return packaging;
    }

    private List<ProcessDeployment.Artifactory> map(List<Artifact.Artifactory> artifactories) {
        return artifactories.stream().map(this::map).collect(Collectors.toList());
    }

    private ProcessDeployment.Artifactory map(Artifact.Artifactory a) {
        ProcessDeployment.Artifactory artifactory = new ProcessDeployment.Artifactory().id(a.mavenId()).url(a.url());
        if (a.authentication() != null) {
            artifactory.user(a.authentication().user()).password(a.authentication().password());
        }
        return artifactory;
    }

    private byte[] bytes(BufferedImage image) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "png", baos);
            return baos.toByteArray();
        }
        catch (IOException e) {
            return new byte[0];
        }
    }

    private Function<io.intino.cesar.graph.ProcessStatus, Double> mapper(String metric) {
        if (metric.equalsIgnoreCase("memory")) {
            return io.intino.cesar.graph.ProcessStatus::memoryUsage;
        }
        if (metric.equalsIgnoreCase("cpu")) {
            return io.intino.cesar.graph.ProcessStatus::cpuUsage;
        }
        if (metric.equalsIgnoreCase("threads")) {
            return processStatus -> processStatus.threads();
        }
        return null;
    }

    private String unit(String metric) {
        if (metric.equalsIgnoreCase("memory")) {
            return "mb";
        }
        if (metric.equalsIgnoreCase("cpu")) {
            return "%";
        }
        if (metric.equalsIgnoreCase("threads")) {
            return "quantity";
        }
        return null;
    }

    private String readLocalLog(Process process) {
        try {
            GetProcessLogAction action = new GetProcessLogAction();
            action.box = this.box;
            action.process = process.name$();
            return action.execute();
        }
        catch (BadRequest e) {
            Logger.error(e);
            return "*Impossible to retrieve log*";
        }
    }

    private String format(String value, int limit) {
        List<String> lines = Arrays.asList(value.split("\n"));
        if (lines.size() > limit) {
            lines = lines.subList(lines.size() - limit, lines.size());
        }
        return "```\n" + String.join((CharSequence)"\n", lines) + "\n```";
    }
}

