/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.bot;

import io.intino.alexandria.exceptions.BadRequest;
import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.MessageManager;
import io.intino.cesar.box.actions.GetServerAction;
import io.intino.cesar.box.bot.ChatSection;
import io.intino.cesar.box.bot.RestBot;
import io.intino.cesar.box.bot.helpers.BotMessageFormatter;
import io.intino.cesar.box.schemas.ServerInfo;
import io.intino.cesar.datahub.events.consul.server.ServerStatus;
import io.intino.cesar.graph.Process;
import io.intino.cesar.graph.Server;
import io.intino.cesar.graph.User;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class ServerContext
extends ChatSection {
    public ServerContext(CesarBox box) {
        super(box);
    }

    public String status(RestBot.MessageProperties properties) {
        Server server = this.findServer(properties);
        if (server == null) {
            return "No server has been connected";
        }
        ServerStatus status = this.box.serverAccessor(server).status();
        if (status != null) {
            return server.label() + "> " + BotMessageFormatter.format(status, properties.timeZone());
        }
        return "Server doesn't response";
    }

    public String responsibles(RestBot.MessageProperties properties) {
        Server server = this.findServer(properties);
        if (server == null) {
            return "No server has been connected";
        }
        StringBuilder builder = new StringBuilder();
        for (User responsible : server.responsibles()) {
            builder.append(responsible.name$());
            builder.append(" ").append(responsible.mail()).append("\n");
        }
        String result = builder.toString();
        return result.isEmpty() ? "No responsibles are registered." : result;
    }

    public String name(RestBot.MessageProperties properties, String newName) {
        Server server = this.findServer(properties);
        if (server == null) {
            return "No server has been connected";
        }
        this.box.committer().commit(MessageManager.infrastructureOperationMessage("rename", properties.username(), server, newName));
        return ":ok_hand:";
    }

    public String remoteConnection(RestBot.MessageProperties properties, String url, Integer port, String sshUser) {
        Server server = this.findServer(properties);
        if (server == null) {
            return "No server has been connected";
        }
        this.box.committer().commit(MessageManager.infrastructureOperationMessage("sshchain", properties.username(), server, url, String.valueOf(port), sshUser));
        return ":ok_hand:";
    }

    public String reboot(RestBot.MessageProperties properties) {
        Server server = this.findServer(properties);
        if (server == null) {
            return "No server has been connected";
        }
        boolean result = this.box.serverAccessor(server).upgrade();
        return server.label() + "> " + (result ? "Rebooting..." : "Couldn't be possible reboot");
    }

    public String log(RestBot.MessageProperties properties) {
        return ":ok_hand:";
    }

    public String upgradeConsul(RestBot.MessageProperties properties) {
        Server server = this.findServer(properties);
        if (server == null) {
            return "No server has been connected";
        }
        boolean result = this.box.serverAccessor(server).upgrade();
        return server.label() + "> " + (result ? "upgraded" : "Couldn't be possible to upgrade consul");
    }

    public String setResponsibles(RestBot.MessageProperties properties, String[] users) {
        List<String> newResponsibleNames = Arrays.asList(users);
        Server server = this.findServer(properties);
        if (server == null) {
            return "No server has been connected";
        }
        List responsibles = this.box.graph().userList(r -> newResponsibleNames.contains(r.name$())).collect(Collectors.toList());
        if (responsibles.size() != newResponsibleNames.size()) {
            return "Some responsible hasn't been found";
        }
        this.box.committer().commit(MessageManager.infrastructureOperationMessage("setresponsibles", properties.username(), server, users));
        return ":ok_hand:";
    }

    public String ssh(RestBot.MessageProperties properties) {
        Server server = this.findServer(properties);
        if (server == null) {
            return "Server not found";
        }
        Server.RemoteConnection connection = server.remoteConnection();
        if (connection == null) {
            return "Remote connection chain is not already defined";
        }
        return "`ssh -p " + connection.port() + " " + connection.user() + "@" + connection.url() + "`";
    }

    public String processes(RestBot.MessageProperties properties) {
        Server server = this.findServer(properties);
        if (server == null) {
            return "Server not found";
        }
        List<Process> processes = this.graph().processesOn(server.name$());
        if (processes.isEmpty()) {
            return "There aren't processes registered";
        }
        StringBuilder result = new StringBuilder();
        int pos = 1;
        for (Process process : processes) {
            result.append("`").append(pos++).append(")` *").append(process.label()).append(" v.").append(process.currentDeployment().artifact().version()).append("*").append(" :").append(this.isRunning(process)).append(": ").append(process.started() ? BotMessageFormatter.format(process, properties.timeZone()) : "").append("\n");
        }
        return result.toString();
    }

    public Object startAllProcesses(RestBot.MessageProperties properties) {
        return "TODO";
    }

    public Object stopAllProcesses(RestBot.MessageProperties properties) {
        return "TODO";
    }

    private String isRunning(Process process) {
        return process.started() ? "started" : "stopped";
    }

    public String removeProcess(RestBot.MessageProperties properties, String nameOrPosition, String additional) {
        Server server = this.findServer(properties);
        if (server == null) {
            return "Server not found";
        }
        Process selected = this.graph().findProcessByPosition(server.name$(), nameOrPosition);
        if (selected == null) {
            return "Process not found";
        }
        boolean result = this.box.serverProcessAccessor(selected).retract();
        if (result || additional.equals("force")) {
            new Thread(() -> this.box.committer().commit(MessageManager.infrastructureOperationMessage("remove", properties.username(), selected, new String[0]))).start();
            return ":ok_hand:";
        }
        return "Server doesn't response";
    }

    public String process(RestBot.MessageProperties properties, String nameOrPosition) {
        Server server = this.findServer(properties);
        if (server == null) {
            return "Server not found";
        }
        Process process = this.graph().findProcessByPosition(server.name$(), nameOrPosition);
        if (process == null) {
            return "Process not found";
        }
        properties.context().command("server|process");
        properties.context().objects(server.name$(), process.identifier());
        return "Connected to " + this.icon(server) + " " + process.identifier();
    }

    public String info(RestBot.MessageProperties properties) {
        Server server = this.findServer(properties);
        if (server == null) {
            return "No server has been connected";
        }
        GetServerAction action = new GetServerAction();
        action.box = this.box;
        action.server = server.name$();
        try {
            ServerInfo info = action.execute();
            return "*id*: " + info.id() + "\n*active*: " + info.active() + "\n*consul*: v." + server.serverConsul().version() + "\n*ip*: " + info.ip() + "\n*apps workspace*: " + server.appsWorkspace() + "\n*architecture*: " + info.architecture() + "\n*os*: " + info.os() + "\n*jvm*: " + info.jvm() + "\n*cores*: " + info.cores() + "\n*memory*: " + info.memorySize() + " Mb\n*hard disk*: " + new DecimalFormat("#.#").format(info.diskSize() / 1024L) + " Gb";
        }
        catch (BadRequest badRequest) {
            return "No server has been connected";
        }
    }

    private Server findServer(RestBot.MessageProperties properties) {
        RestBot.Context context = properties.context();
        if (context == null) {
            return null;
        }
        Server server = this.box.graph().server(context.getObjects()[0]);
        return server == null ? this.graph().findServerByPosition(context.getObjects()[0]) : server;
    }
}

